% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasetsTCGA.R
\name{datasetsTCGA}
\alias{datasetsTCGA}
\alias{RTCGA.data}
\title{RTCGA - The Family of R Packages with Data from The Cancer Genome Atlas Study}
\description{
Snapshots of the clinical, mutations, CNVs, rnaseq, RPPA, mRNA, miRNASeq and methylation datasets from the \code{2016-01-28}
release date (check all dates of release with \code{checkTCGA('Dates')}) are included in the \code{RTCGA} family (factory) that contains below packages:
\itemize{
 \item \pkg{RTCGA.rnaseq.20160128} \link[RTCGA.rnaseq.20160128]{rnaseq.20160128}
 \item \pkg{RTCGA.clinical.20160128} \link[RTCGA.clinical.20160128]{clinical.20160128}
 \item \pkg{RTCGA.mutations.20160128} \link[RTCGA.mutations.20160128]{mutations.20160128}
 \item \pkg{RTCGA.CNV.20160128} \link[RTCGA.CNV.20160128]{CNV.20160128}
 \item \pkg{RTCGA.RPPA.20160128} \link[RTCGA.RPPA.20160128]{RPPA.20160128}
 \item \pkg{RTCGA.mRNA.20160128} \link[RTCGA.mRNA.20160128]{mRNA.20160128}
 \item \pkg{RTCGA.miRNASeq.20160128} \link[RTCGA.miRNASeq.20160128]{miRNASeq.20160128}
 \item \pkg{RTCGA.methylation.20160128} \link[RTCGA.methylation.20160128]{methylation.20160128}
 }
 
Snapshots of the clinical, mutations, CNVs, rnaseq, RPPA, mRNA, miRNASeq and methylation datasets from the \code{2015-11-01}
release date (check all dates of release with \code{checkTCGA('Dates')}) are also included in the \code{RTCGA} family (factory).
\itemize{
 \item \pkg{RTCGA.rnaseq} \link[RTCGA.rnaseq]{rnaseq}
 \item \pkg{RTCGA.clinical} \link[RTCGA.clinical]{clinical}
 \item \pkg{RTCGA.mutations} \link[RTCGA.mutations]{mutations}
 \item \pkg{RTCGA.CNV} \link[RTCGA.CNV]{CNV}
 \item \pkg{RTCGA.RPPA} \link[RTCGA.RPPA]{RPPA}
 \item \pkg{RTCGA.mRNA} \link[RTCGA.mRNA]{mRNA}
 \item \pkg{RTCGA.miRNASeq} \link[RTCGA.miRNASeq]{miRNASeq}
 \item \pkg{RTCGA.methylation} \link[RTCGA.methylation]{methylation}
 \item \pkg{RTCGA.PANCAN12} (not from TCGA) 
 }
}
\details{
For more detailed information visit \pkg{RTCGA} family  website
\href{https://rtcga.github.io/RTCGA}{https://rtcga.github.io/RTCGA}. One can install all data packages with \link{installTCGA}.
}
\section{Issues}{


If you have any problems, issues or think that something is missing or is not
clear please post an issue on 
\href{https://github.com/RTCGA/RTCGA/issues}{https://github.com/RTCGA/RTCGA/issues}.
}

\examples{


# installation of packages containing snapshots
# of TCGA project's datasets

\dontrun{

## RTCGA GitHub development newest versions
library(RTCGA)
?installTCGA

## Bioconductor releases for data from 2016-01-28 release
source('http://bioconductor.org/biocLite.R')
biocLite(RTCGA.clinical.20160128)
biocLite(RTCGA.mutations.20160128)
biocLite(RTCGA.rnaseq.20160128)
biocLite(RTCGA.CNV.20160128)
biocLite(RTCGA.RPPA.20160128)
biocLite(RTCGA.mRNA.20160128)
biocLite(RTCGA.miRNASeq.20160128)
biocLite(RTCGA.methylation.20160128)

## Bioconductor releases for data from 2015-11-01 release
source('http://bioconductor.org/biocLite.R')
biocLite(RTCGA.clinical)
biocLite(RTCGA.mutations)
biocLite(RTCGA.rnaseq)
biocLite(RTCGA.CNV)
biocLite(RTCGA.RPPA)
biocLite(RTCGA.mRNA)
biocLite(RTCGA.miRNASeq)
biocLite(RTCGA.methylation)

# use cases and examples + more data info
browseVignettes('RTCGA')
}

}
\seealso{
\pkg{RTCGA} website \href{http://rtcga.github.io/RTCGA}{http://rtcga.github.io/RTCGA}.

Other RTCGA: 
\code{\link{RTCGA-package}},
\code{\link{boxplotTCGA}()},
\code{\link{checkTCGA}()},
\code{\link{convertTCGA}()},
\code{\link{downloadTCGA}()},
\code{\link{expressionsTCGA}()},
\code{\link{heatmapTCGA}()},
\code{\link{infoTCGA}()},
\code{\link{installTCGA}()},
\code{\link{kmTCGA}()},
\code{\link{mutationsTCGA}()},
\code{\link{pcaTCGA}()},
\code{\link{readTCGA}()},
\code{\link{survivalTCGA}()},
\code{\link{theme_RTCGA}()}
}
\author{
Marcin Kosinski [aut, cre] \email{ m.p.kosinski@gmail.com } \cr
Przemyslaw Biecek [aut] \email{ przemyslaw.biecek@gmail.com } \cr
Witold Chodor [aut] \email{ witoldchodor@gmail.com }
}
\concept{RTCGA}
