% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGISTICPeaks.R
\name{getGISTICPeaks}
\alias{getGISTICPeaks}
\title{Download GISTIC2 peak-level data from the Firehose pipeline}
\usage{
getGISTICPeaks(object, peak = c("wide", "narrow", "full"), rm.chrX = TRUE)
}
\arguments{
\item{object}{A FirehoseData GISTIC type object}

\item{peak}{The peak type, select from "wide", "narrow", "full".}

\item{rm.chrX}{(logical default TRUE) Whether to remove observations in the
X chromosome}
}
\value{
A \code{data.frame} of peak values
}
\description{
Access GISTIC2 level 4 copy number data through
\code{gdac.broadinstitute.org}
}
\examples{

co <- getFirehoseData("COAD", clinical = FALSE, GISTIC = TRUE)
peaks <- getGISTICPeaks(co, "wide")
class(peaks)
head(peaks)[1:6]

}
\author{
Ludwig Geistlinger
}
