% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pointsCurve.R
\name{pointsCurve}
\alias{pointsCurve}
\title{Points of the ROC curve}
\usage{
pointsCurve(x, y)
}
\arguments{
\item{x}{It is the vector of the status (gold standar)}

\item{y}{It is the vector with the values of a predictor
variable or clasificator}
}
\value{
return a matrix with the points of 1-specificity and
sensibility that will be used to generate a ROC curve
}
\description{
It calculates the coordinates (fpr, sen) of the ROC curve.
This function sorts the scores of a model test and generates
the points which will be used to plot its the ROC curve
}
\examples{
library(fission)
data("fission")
strain <- fission@colData@listData$strain
pointsCurve<- pointsCurve(strain, t(assay(fission))[,"SPNCRNA.1080"])
}
