% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Modifier-class.R,
%   R/ModifierSet-class.R
\name{modify}
\alias{modify}
\alias{findMod}
\alias{modifications,Modifier-method}
\alias{modifications}
\alias{modify,Modifier-method}
\alias{findMod,Modifier-method}
\alias{modify,ModifierSet-method}
\title{Searching for modifications in \code{SequenceData}}
\usage{
modifications(x, ...)

modify(x, ...)

findMod(x)

\S4method{modifications}{Modifier}(x, perTranscript = FALSE)

\S4method{modify}{Modifier}(x, force = FALSE)

\S4method{findMod}{Modifier}(x)

\S4method{modify}{ModifierSet}(x, force = FALSE)
}
\arguments{
\item{x}{a \code{Modifier} object.}

\item{...}{additional arguments}

\item{perTranscript}{For \code{modifications>} \code{TRUE} or \code{FALSE}:
Should the coordinates be returned as local per transcript coordinates?}

\item{force}{force to run \code{aggregate} again, if data is already stored
in \code{x}.}
}
\value{
\itemize{
\item \code{modify}: the updated \code{Modifier} object.
\item \code{modifications}: the modifications found as a \code{GRanges}
object.
}
}
\description{
The \code{modify} function executes the search for modifications for a
\code{\link[=Modifier-class]{Modifier}} class. Usually this is done
automatically during construction of a \code{Modifier} object.

When the \code{modify} functions is called, the aggregated data is checked
for validity for the current settings and the search for modifications is
performed using the \code{findMod}. The results are stored in the
\code{modification} slot of the \code{Modifier} object, which is returned by
\code{modify}. The results can be accessed via the \code{modifications()}
function.

\code{findMod} returns the found modifications as a \code{GRanges}
object and has to be implemented for each individual \code{Modifier} class.
}
\examples{
data(msi,package="RNAmodR")
# modify() triggers the search for modifications in the data contained in
# the Modifier or ModifierSet object
mi <- modify(msi[[1]])
}
