% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SequenceData-class.R
\name{SequenceData-class}
\alias{SequenceData-class}
\alias{SequenceData}
\alias{cbind,SequenceData-method}
\alias{rbind,SequenceData-method}
\alias{SequenceData,character,character-method}
\alias{SequenceData,character,BSgenome-method}
\alias{SequenceData,TxDb,character-method}
\alias{SequenceData,TxDb,BSgenome-method}
\alias{SequenceData,GRangesList,character-method}
\alias{SequenceData,GRangesList,BSgenome-method}
\alias{SequenceData,GFF3File,BSgenome-method}
\alias{SequenceData,GFF3File,character-method}
\alias{SequenceData,character,FaFile-method}
\alias{SequenceData,GFF3File,FaFile-method}
\alias{SequenceData,TxDb,FaFile-method}
\alias{SequenceData,GRangesList,FaFile-method}
\title{The SequenceData class}
\usage{
\S4method{cbind}{SequenceData}(..., deparse.level = 1)

\S4method{rbind}{SequenceData}(..., deparse.level = 1)

SequenceData(dataType, bamfiles, annotation, sequences, seqinfo, ...)

\S4method{SequenceData}{character,character}(dataType, bamfiles, annotation, sequences, seqinfo, ...)

\S4method{SequenceData}{character,BSgenome}(dataType, bamfiles, annotation, sequences, seqinfo, ...)

\S4method{SequenceData}{TxDb,character}(dataType, bamfiles, annotation, sequences, seqinfo, ...)

\S4method{SequenceData}{TxDb,BSgenome}(dataType, bamfiles, annotation, sequences, seqinfo, ...)

\S4method{SequenceData}{GRangesList,character}(dataType, bamfiles, annotation, sequences, seqinfo, ...)

\S4method{SequenceData}{GRangesList,BSgenome}(dataType, bamfiles, annotation, sequences, seqinfo, ...)

\S4method{SequenceData}{GFF3File,BSgenome}(dataType, bamfiles, annotation, sequences, seqinfo, ...)

\S4method{SequenceData}{GFF3File,character}(dataType, bamfiles, annotation, sequences, seqinfo, ...)

\S4method{SequenceData}{character,FaFile}(dataType, bamfiles, annotation, sequences, seqinfo, ...)

\S4method{SequenceData}{GFF3File,FaFile}(dataType, bamfiles, annotation, sequences, seqinfo, ...)

\S4method{SequenceData}{TxDb,FaFile}(dataType, bamfiles, annotation, sequences, seqinfo, ...)

\S4method{SequenceData}{GRangesList,FaFile}(dataType, bamfiles, annotation, sequences, seqinfo, ...)
}
\arguments{
\item{...}{Optional arguments overwriting default values. Not all
\code{SequenceData} classes use all arguments. The arguments are:
\itemize{
\item \code{minLength}: single integer value setting a threshold for minimum
read length. Shorther reads are discarded (default: \code{minLength = NA}).
\item \code{maxLength}: single integer value setting a threshold for maximum
read length. Longer reads are discarded (default: \code{maxLength = NA}).
\item \code{minQuality}: single integer value setting a threshold for maximum
read quality. Reads with a lower quality are discarded (default:
\code{minQuality = 5L}, but this is class dependent).
\item \code{max_depth}: maximum depth for pileup loading (default:
\code{max_depth = 10000L}).
}}

\item{deparse.level}{See \code{\link[base:cbind]{base::cbind}} for a
description of this argument.}

\item{dataType}{The prefix for construction the class name of the
\code{SequenceData} subclass to be constructed.}

\item{bamfiles}{the input which can be of the following types
\itemize{
\item \code{BamFileList}: a named \code{BamFileList}
\item \code{character}: a \code{character} vector, which must be coercible
to a named \code{BamFileList} referencing existing bam files. Valid names are
\code{control} and \code{treated} to define conditions and replicates
}}

\item{annotation}{annotation data, which must match the information contained
in the BAM files.}

\item{sequences}{sequences matching the target sequences the reads were
mapped onto. This must match the information contained in the BAM files.}

\item{seqinfo}{optional \code{\link[Seqinfo:Seqinfo-class]{Seqinfo}} to
subset the transcripts analyzed on a chromosome basis.}
}
\value{
A SequenceData object
}
\description{
The \code{SequenceData} class is implemented to contain data on each position
along transcripts and holds the corresponding annotation data and
nucleotide sequence of these transcripts. To access this data several
\code{\link[=SequenceData-functions]{functions}} are available. The
\code{SequenceData} class is a virtual class, from which specific classes can
be extended. Currently the following classes are implemented:

\itemize{
\item \code{\link[=CoverageSequenceData-class]{CoverageSequenceData}}
\item \code{\link[=EndSequenceData-class]{End5SequenceData}},
\code{\link[=EndSequenceData-class]{End3SequenceData}},
\code{\link[=EndSequenceData-class]{EndSequenceData}}
\item \code{\link[=NormEndSequenceData-class]{NormEnd5SequenceData}},
\code{\link[=NormEndSequenceData-class]{NormEnd5SequenceData}}
\item \code{\link[=PileupSequenceData-class]{PileupSequenceData}}
\item \code{\link[=ProtectedEndSequenceData-class]{ProtectedEndSequenceData}}
}

The annotation and sequence data can be accessed through the functions
\code{ranges} and \code{sequences}, respectively. Beaware, that the data is
always provided according to genomic positions with increasing
\code{rownames}, but the sequence is given as the actual sequence of the
transcript. Therefore, it is necessary to treat the minus strand accordingly.

The \code{SequenceData} class is derived from the
\code{\link[IRanges:DataFrameList-class]{CompressedSplitDataFrameList}} class
with additional slots for annotation and sequence data. Some functionality is
not inherited and might not available to full extend, e.g.\code{relist}.

\strong{SequenceDataFrame}

The \code{SequenceDataFrame} class is a virtual class and  contains data for
positions along a single transcript. In addition to being used for returning
elements from a \code{SequenceData} object, the SequenceDataFrame class is
used to store the unlisted data within a
\code{\link[=SequenceData-class]{SequenceData}} object. Therefore, a matching
\code{SequenceData} and \code{SequenceDataFrame} class must be implemented.

The \code{SequenceDataFrame} class is derived from the
\code{\link[S4Vectors:DataFrame-class]{DataFrame}} class.

Subsetting of a \code{SequenceDataFrame} returns a \code{SequenceDataFrame} or
\code{DataFrame}, if it is subset by a column or row, respectively. The
\code{drop} argument is ignored for column subsetting.
}
\section{Slots}{

\describe{
\item{\code{sequencesType}}{a \code{character} value for the class name of
\code{sequences}. Either \code{RNAStringSet}, \code{ModRNAStringSet},
\code{DNAStringSet} or \code{ModDNAStringSet}.}

\item{\code{minQuality}}{a \code{integer} value describing a threshold of the minimum
quality of reads to be used.}
}}

