% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SequenceData-coverage.R
\docType{class}
\name{CoverageSequenceData-class}
\alias{CoverageSequenceData-class}
\alias{CoverageSequenceData}
\alias{CoverageSequenceDataFrame}
\alias{CoverageSequenceDataFrame-class}
\alias{getData,CoverageSequenceData,BamFileList,GRangesList,XStringSet,ScanBamParam-method}
\alias{aggregateData,CoverageSequenceData-method}
\alias{getDataTrack,CoverageSequenceData-method}
\title{CoverageSequenceData}
\usage{
CoverageSequenceDataFrame(
  df,
  ranges,
  sequence,
  replicate,
  condition,
  bamfiles,
  seqinfo
)

CoverageSequenceData(bamfiles, annotation, sequences, seqinfo, ...)

\S4method{getData}{CoverageSequenceData,BamFileList,GRangesList,XStringSet,ScanBamParam}(x, bamfiles, grl, sequences, param, args)

\S4method{aggregateData}{CoverageSequenceData}(x, condition = c("Both", "Treated", "Control"))

\S4method{getDataTrack}{CoverageSequenceData}(x, name, ...)
}
\arguments{
\item{df, ranges, sequence, replicate}{inputs for creating a 
\code{SequenceDataFrame}. See 
\code{\link[=SequenceDataFrame-class]{SequenceDataFrame}}.}

\item{condition}{For \code{\link{aggregate}}: condition for which the data 
should be aggregated.}

\item{bamfiles, annotation, seqinfo, grl, sequences, param, args, ...}{See 
\code{\link[=SequenceData-class]{SequenceData}}}

\item{x}{a \code{CoverageSequenceData}}

\item{name}{For \code{getDataTrack}: a valid transcript name. Must be a name
of \code{ranges(x)}}
}
\value{
a \code{CoverageSequenceData} object
}
\description{
\code{CoverageSequenceData} implements
\code{\link[=SequenceData-class]{SequenceData}} to contain and aggregate the
coverage of reads per position along the transcripts.

\code{CoverageSequenceData} contains one column per data file named using the
following naming convention \code{coverage.condition.replicate}.

\code{aggregate} calculates the mean and sd for samples in the \code{control}
and \code{treated} condition separatly.
}
\examples{
# Construction of a CoverageSequenceData object
library(RNAmodR.Data)
library(rtracklayer)
annotation <- GFF3File(RNAmodR.Data.example.man.gff3())
sequences <- RNAmodR.Data.example.man.fasta()
files <- c(treated = RNAmodR.Data.example.wt.1())
csd <- CoverageSequenceData(files, annotation = annotation,
                            sequences = sequences)
}
