% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webAccess.R
\name{getCtsRecord}
\alias{getCtsRecord}
\title{Retrieve information from CTS}
\usage{
getCtsRecord(key)
}
\arguments{
\item{key}{The InChI key.}
}
\value{
Returns a list with all information from CTS: \code{inchikey, 
	inchicode, formula, exactmass} contain single values. \code{synonyms} contains
an unordered list of scored synonyms (\code{type, name, score}, where \code{type}
indicates either a normal name or a specific IUPAC name, see below).
 \code{externalIds} contains an unordered list of identifiers of the compound in 
various databases (\code{name, value}, where \code{name} is the database name and
\code{value} the identifier in that database.)
}
\description{
Retrieves a complete CTS record from the InChI key.
}
\note{
Currently, the CTS results are still incomplete; the name scores are all 0,
formula and exact mass return zero.
}
\examples{
data <- getCtsRecord("UHOVQNZJYSORNB-UHFFFAOYSA-N")
# show all synonym "types"
types <- unique(unlist(lapply(data$synonyms, function(i) i$type)))
\dontrun{print(types)}

}
\references{
Chemical Translation Service:
\url{https://cts.fiehnlab.ucdavis.edu}
}
\author{
Michele Stravs, Eawag <stravsmi@eawag.ch>
}
