% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leMsmsRaw.R
\name{findMsMsHRperMsp}
\alias{findMsMsHRperMsp}
\alias{findMsMsHRperMsp.direct}
\title{Retrieve spectra from msp files}
\usage{
findMsMsHRperMsp(fileName, cpdIDs, mode = "pH")

findMsMsHRperMsp.direct(fileName, cpdIDs, mode = "pH")
}
\arguments{
\item{fileName}{vector of character-strings
The msp files to be searched for spectra}

\item{cpdIDs}{vector of integers
The IDs of compounds in the compoundlist
for which spectra should be retrieved}

\item{mode}{character, default: "pH"
The processing mode that was used to produce the spectrum.
Should be one of
"pH": ([M+H]+)
"pNa": ([M+Na]+)
"pM": ([M]+)
"mH": ([M-H]-)
or "mFA": ([M+FA]-)
(see the \code{RMassBank} vignette)}
}
\value{
An \code{RmbSpectraSet} with integrated information from the msp files
}
\description{
This function is currently used to read msp files
containing data that were already processed in order to
convert the results to MassBank records.
}
\section{Functions}{
\itemize{
\item \code{findMsMsHRperMsp.direct()}: A submethod of findMsMsHrperxcms that retrieves basic spectrum data

}}
