Genome-Wide Nucleosome Positioning using High-Throughput Short-Read Data (MNase-Seq)
=====================

[![Build Status](https://travis-ci.org/ArnaudDroitLab/RJMCMCNucleosomes.svg?branch=master)](https://travis-ci.org/ArnaudDroitLab/RJMCMCNucleosomes)
[![codecov](https://codecov.io/gh/ArnaudDroitLab/RJMCMCNucleosomes/branch/master/graph/badge.svg)](https://codecov.io/gh/ArnaudDroitLab/RJMCMCNucleosomes)

This package uses informative Multinomial-Dirichlet prior in a t-mixture with 
reversible jump estimation of nucleosome positions for genome-wide profiling.

This package is in R with an optimized section in C++.


## Citing ##

If you use this package for a publication, we would ask you to cite the following:

> Samb R, Khadraoui K, Belleau P, et al. (2015). "Using informative Multinomial-Dirichlet prior in a t-mixture with reversible jump estimation of nucleosome positions for genome-wide profiling." Statistical Applications in Genetics and Molecular Biology. Volume 14, Issue 6, Pages 517-532, ISSN (Online) 1544-6115, ISSN (Print) 2194-6302, December 2015, <a href="http://dx.doi.org/10.1515/sagmb-2014-0098">doi: 10.1515/sagmb-2014-0098</a>


## Bioconductor Package ##

[![Bioconductor Time](http://bioconductor.org/shields/years-in-bioc/RJMCMCNucleosomes.svg)](http://bioconductor.org/packages/release/bioc/html/RJMCMCNucleosomes "Bioconductor status")

_RJMCMCNucleosomes_ is now an official package of [Bioconductor](http://bioconductor.org/). The current release can be directly downloaded from their website:
[Current release](http://bioconductor.org/packages/RJMCMCNucleosomes/)


## Notes ##

To use this current _RJMCMCNucleosomes_ version, the use of the Rcpp package is mandatory. This implies having GSL library installed.


## Authors ##

[Pascal Belleau](http://ca.linkedin.com/in/pascalbelleau 
"Pascal Belleau"),
[Rawane Samb](https://ca.linkedin.com/in/rawanesamb "Rawane Samb"), 
[Astrid Desch&ecirc;nes](http://ca.linkedin.com/in/astriddeschenes 
"Astrid Desch&ecirc;nes"), 
[Khader Khadraoui](http://archimede.mat.ulaval.ca/pages/khaderk/ "Khader Khadraoui"), 
[Lajmi Lakhal-Chaieb](https://www.researchgate.net/profile/Lajmi_Lakhal-Chaieb "Lajmi Lakhal-Chaieb")
and [Arnaud Droit](http://ca.linkedin.com/in/drarnaud "Arnaud Droit").

See [AD Lab](http://compbio.ulaval.ca/ "AD Lab") website.


## Maintainer ##

[Astrid Desch&ecirc;nes](http://ca.linkedin.com/in/astriddeschenes 
"Astrid Desch&ecirc;nes")


## License ##

This package and the underlying _RJMCMCNucleosomes_ code are distributed under the 
Artistic license 2.0. You are free to use and redistribute this software. 

For more information on Artistic 2.0 License see
[http://opensource.org/licenses/Artistic-2.0](http://opensource.org/licenses/Artistic-2.0)


## Bugs/Feature requests ##

If you have any bugs or feature requests, [let us know](https://github.com/ArnaudDroitLab/RJMCMCNucleosomes/issues). 

Thanks!
