% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Study.R
\name{serialzeStudyData}
\alias{serialzeStudyData}
\title{Serialize the Study Data}
\usage{
serialzeStudyData(study_ids, data_dir)
}
\arguments{
\item{study_ids}{List of study indentifiers}

\item{data_dir}{Path to a file folder where the .rds study files will be saved into}
}
\value{
List of study indentifiers that were serialized successfully
}
\description{
Load specific studies from the database and save it in .rds format in 
a local file directory
}
\examples{
library(DBI)
library(sqldf)
studies_dir <- system.file("extdata", "ImmPortStudies", package = "RImmPort")
db_dir <- file.path(studies_dir, "Db")
sqlite_conn <- dbConnect(SQLite(), dbname=file.path(db_dir, "ImmPort.sqlite"))
setImmPortDataSource(sqlite_conn)
# the folder where the .rds files will be stored
rds_dir <- file.path(studies_dir, "Rds")
study_ids <- c('SDY139', 'SDY208')
serialzeStudyData(study_ids, rds_dir)
}

