% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_01_load_data.R
\name{createRflomicsMAE}
\alias{createRflomicsMAE}
\title{RflomicsMAE class constructor}
\usage{
createRflomicsMAE(
  projectName = NULL,
  omicsData = NULL,
  omicsNames = NULL,
  omicsTypes = NULL,
  ExpDesign = NULL,
  factorInfo = NULL
)
}
\arguments{
\item{projectName}{Project name}

\item{omicsData}{list of omics dataset: named list of data.frame, matrix or
\link{SummarizedExperiment} objects, or \link{MultiAssayExperiment} object.}

\item{omicsNames}{Vector of dataset names that we want to analyze.}

\item{omicsTypes}{vector of dataset types:
"RNAseq", "metabolomics", "proteomics"}

\item{ExpDesign}{a data.frame which describes the experimental design.}

\item{factorInfo}{a data.frame describing the experimental factors.
\itemize{
\item factorName: factor names
\item factorRef: factor references
\item factorType: factor type : "Bio", "batch", "Meta"
\item factorLevels: levels of each factor with "," separation.
}}
}
\value{
An object of class \link{RflomicsMAE-class}
}
\description{
This function is a constructor for the class
 \link{RflomicsMAE-class}.
It initializes an object of class \link{RflomicsMAE-class}
from a list of omics datasets, a vector of dataset names,
a vector of omics types, and an experimental design.
}
\examples{
# load ecoseed data
data(ecoseed.mae)

factorInfo <- data.frame(
  "factorName"   = c("Repeat", "temperature", "imbibition"),
  "factorType"   = c("batch", "Bio", "Bio")
)

# create rflomicsMAE object with ecoseed data
MAE <- RFLOMICS::createRflomicsMAE(
  projectName = "Tests",
  omicsData   = ecoseed.mae,
  omicsTypes  = c("RNAseq","proteomics","metabolomics"),
  factorInfo  = factorInfo)
names(MAE) <- c("RNAtest", "protetest", "metatest")

# generate upset plot
# MultiAssayExperiment::upsetSamples(MAE)

# generate data overview plot
# plotDataOverview(MAE)

# generate plot of coverage of condition by data
# plotConditionsOverview(MAE)
}
\seealso{
\link{RflomicsMAE-class}
}
