% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFLOMICS-Class.R,
%   R/RFLOMICS-Methods_01_load_data.R
\docType{class}
\name{RflomicsMAE-class}
\alias{RflomicsMAE-class}
\alias{getProjectName}
\alias{getProjectName,RflomicsMAE-method}
\alias{getDesignMat}
\alias{getDesignMat,RflomicsMAE-method}
\alias{getDatasetNames}
\alias{getDatasetNames,RflomicsMAE-method}
\alias{getOmicsTypes}
\alias{getOmicsTypes,RflomicsMAE-method}
\alias{getFactorNames}
\alias{getFactorNames,RflomicsMAE-method}
\alias{getFactorTypes}
\alias{getFactorTypes,RflomicsMAE-method}
\alias{getBioFactors}
\alias{getBioFactors,RflomicsMAE-method}
\alias{getBatchFactors}
\alias{getBatchFactors,RflomicsMAE-method}
\alias{getMetaFactors}
\alias{getMetaFactors,RflomicsMAE-method}
\alias{getRflomicsSE}
\alias{getRflomicsSE,RflomicsMAE-method}
\alias{getFactorModalities}
\alias{getFactorModalities,RflomicsMAE-method}
\alias{subRflomicsMAE}
\alias{subRflomicsMAE,RflomicsMAE-method}
\alias{plotDataOverview}
\alias{plotDataOverview,RflomicsMAE-method}
\alias{plotConditionsOverview}
\alias{plotConditionsOverview,RflomicsMAE-method}
\title{RflomicsMAE Class}
\usage{
\S4method{getProjectName}{RflomicsMAE}(object)

\S4method{getDesignMat}{RflomicsMAE}(object)

\S4method{getDatasetNames}{RflomicsMAE}(object)

\S4method{getOmicsTypes}{RflomicsMAE}(object)

\S4method{getFactorNames}{RflomicsMAE}(object)

\S4method{getFactorTypes}{RflomicsMAE}(object)

\S4method{getBioFactors}{RflomicsMAE}(object)

\S4method{getBatchFactors}{RflomicsMAE}(object)

\S4method{getMetaFactors}{RflomicsMAE}(object)

\S4method{getRflomicsSE}{RflomicsMAE}(object, datasetName = NULL)

\S4method{getFactorModalities}{RflomicsMAE}(object, factorName)

\S4method{subRflomicsMAE}{RflomicsMAE}(object, omicNames = NULL)

\S4method{plotDataOverview}{RflomicsMAE}(
  object,
  omicNames = NULL,
  realSize = FALSE,
  raw = FALSE,
  completeCases = FALSE
)

\S4method{plotConditionsOverview}{RflomicsMAE}(object, omicNames = NULL)
}
\arguments{
\item{object}{An object of class \link{RflomicsMAE-class}}

\item{datasetName}{the name of the RflomicsSE to retrieve}

\item{factorName}{factor name}

\item{omicNames}{a vector with dataset names}

\item{realSize}{booleen value, influence the display size}

\item{raw}{boolean. If TRUE, displays the raw data without any selection. If
FALSE, displays the data with removed samples.}

\item{completeCases}{boolean. If true, only shows the complete cases of the
object.}
}
\value{
A \code{RflomicsMAE} object.
}
\description{
RflomicsMAE is a class that extends the \link{MultiAssayExperiment}
class by imposing a structure to the metadata slot. This class is used by
the Rflomics analysis workflow to store the experimental design, the settings
and results of a multi-omics integration analysis.
}
\section{Slots}{

 \itemize{
   \item ExperimentList:
     \itemize{
       \item A ExperimentList class object of \link{RflomicsSE} object
       for each assay dataset
       }
   \item colData: see \code{\link{MultiAssayExperiment}}
   \item sampleMap: see \code{\link{MultiAssayExperiment}}
   \item metadata:
     \itemize{
       \item projectName: string. Project name.
       \item omicList: list. Contains the list of omics datasets, with the
       type and name.
       \item design: The experimental design.
       \item IntegrationAnalysis: A list containing the multi-omics
       integration analysis settings and results.
       \item design: The experimental design
       \item sessionInfo:
       \item IntegrationAnalysis: A list containing the multi-omics
       integration analysis settings and results.
       }
}
}

\section{Consructor}{

\code{\link{createRflomicsMAE}}
}

\section{Accessors}{



\itemize{
  \item getProjectName: return a string with the name of the project}


\itemize{
   \item getDesignMat: return a data.frame with experimental design.}


\itemize{
   \item getDatasetNames: return a vector with dataset names.}


\itemize{
   \item getOmicsTypes: return a named vector with omics type of each
   dataset ("RNAseq", "proteomics", "metabolomics")}


\itemize{
   \item getFactorNames: return a vector with the experimental factor names.}


\itemize{
   \item getFactorTypes: return a named vector with experimental factor types
   ("bio", "batch" or "meta").}


\itemize{
   \item getBioFactors: return a vector with the biological factor names.}


\itemize{
   \item getBatchFactors: return a vector with the batch factor names.}


\itemize{
   \item getMetaFactors: return a vector with the metadata factor names.}


\itemize{
   \item getRflomicsSE: return a \link{RflomicsSE} object with selected
   dataset}


\itemize{
   \item getFactorModalities: return a vector with the modality names of
   selected factor.}


\itemize{
   \item subRflomicsMAE: return a \link{RflomicsMAE-class} object with selected
   datasets.}
}

\section{Plots}{



\itemize{
   \item plotDataOverview:
This function plot an overview of the loaded datasets displaying per sample
(n=number of entities (genes/metabolites/proteins); k=number of samples)}


\itemize{
   \item plotConditionsOverview:
A complete design and at least one biological and one batch factors are
required for using RFLOMICS workflow.}
}

\section{Methods}{

\code{\link{generateModelFormulae}}
\code{\link{generateExpressionContrast}}
\code{\link{runDataProcessing}}
\code{\link{runDataProcessing}}
\code{\link{runDiffAnalysis}}
\code{\link{runCoExpression}}
\code{\link{runAnnotationEnrichment}}
}

\examples{
# load ecoseed data
data(ecoseed.mae)

factorInfo <- data.frame(
  "factorName"   = c("Repeat", "temperature", "imbibition"),
  "factorType"   = c("batch", "Bio", "Bio")
)

# create rflomicsMAE object with ecoseed data
MAE <- RFLOMICS::createRflomicsMAE(
  projectName = "Tests",
  omicsData   = ecoseed.mae,
  omicsTypes  = c("RNAseq","proteomics","metabolomics"),
  factorInfo  = factorInfo)
names(MAE) <- c("RNAtest", "protetest", "metatest")

# generate upset plot
# MultiAssayExperiment::upsetSamples(MAE)

# generate data overview plot
# plotDataOverview(MAE)

# generate plot of coverage of condition by data
# plotConditionsOverview(MAE)
# See createRflomicsMAE for an example that includes plotDataOverview
# See createRflomicsMAE for an example that includes plotConditionsOverview
}
\seealso{
\code{\link{MultiAssayExperiment}}
}
