## ----echo = FALSE-------------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  warning = FALSE,
  message = FALSE,
  echo = FALSE,
  comment = "#>"
)


## ----echo=FALSE---------------------------------------------------------------
library(RFLOMICS)

## ----ImportDesign, output="asis"----------------------------------------------
data(ecoseed.df)
DT::datatable(ecoseed.df$design)

## ----RNAseq, output="asis"----------------------------------------------------
geneCount  <- ecoseed.df$RNAtest
DT::datatable(geneCount[1:10, 1:5])

## ----Proteomics, output="asis"------------------------------------------------
protAbundance <- ecoseed.df$protetest
DT::datatable(protAbundance[1:10, 1:5])

## ----Metabolomics, output="asis"----------------------------------------------
metaAbundance <- ecoseed.df$metatest
DT::datatable(metaAbundance[1:10, 1:5])

