% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AspectDependencies.R
\name{setExtension}
\alias{setExtension}
\title{Set or register an RCX extension}
\usage{
setExtension(package, accession, className)
}
\arguments{
\item{package}{character; name of the extension package}

\item{accession}{character; accession name used in \link[=RCX-object]{RCX} (e.g. \code{rcx$accessionName})}

\item{className}{character; class name of the aspect (e.g. \code{is(rcx$accessionName, "AccessionNameAspect")})}
}
\value{
\code{options()$RCX.options$extensions}
}
\description{
To simplify the usage of extension of the \link[=RCX-object]{RCX} data model new extensions can easily registered on load with this function.
Registered extension then automatically are used for the conversion of CX data containing aspects of these extensions.
The accession names and classes then are also added to \link[=aspectClasses]{getAspectClasses}.
}
\examples{
\donttest{
setExtension("RCXMyRcxExtension", "myRcxExtension", "MyRcxExtensionAspect")
}
}
\seealso{
\link{aspectClasses}
}
