% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AspectDependencies.R
\name{idProperty}
\alias{idProperty}
\alias{idProperty.default}
\alias{idProperty.NodesAspect}
\alias{idProperty.EdgesAspect}
\alias{idProperty.CyGroupsAspect}
\alias{idProperty.CySubNetworksAspect}
\title{Name of the property of an aspect that is an ID}
\usage{
idProperty(aspect)

\method{idProperty}{default}(aspect)

\method{idProperty}{NodesAspect}(aspect)

\method{idProperty}{EdgesAspect}(aspect)

\method{idProperty}{CyGroupsAspect}(aspect)

\method{idProperty}{CySubNetworksAspect}(aspect)
}
\arguments{
\item{aspect}{an object of one of the aspect classes (e.g. NodesAspect, EdgesAspect, etc.)}
}
\value{
character; Name of the ID property or \emph{NULL}
}
\description{
This function returns the name of the property, if an aspect uses IDs for its elements.
As example, the aspect \emph{NodesAspect} has the property \emph{id} that represents the IDs of
the aspect.
}
\details{
By default aspects don't have IDs, so only the implemented classes have IDs.
Aspects with IDs will be considered in the meta-data aspect to determine properties like:
\emph{idCounter} and \emph{elementCount}.

Uses method dispatch, so the default return is \emph{NULL} and only aspect classes with IDs are
implemented. This way it is easier to extend the data model.
}
\examples{
edges = createEdges(source = c(0,0), target = c(1,2))
idProperty(edges)
}
\seealso{
\code{\link[=hasIds]{hasIds()}}, \code{\link[=refersTo]{refersTo()}}, \code{\link[=referredBy]{referredBy()}}, \code{\link[=maxId]{maxId()}}
}
