% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils-general.R
\name{.log}
\alias{.log}
\title{Logging (printing) the results of test cases}
\usage{
.log(info, pass, sep = "...", spaceLine = FALSE)
}
\arguments{
\item{info}{character; description of the test case.}

\item{pass}{boolean; was the test passed?}

\item{sep}{character (default="..."); separates description from result.}

\item{spaceLine}{boolean (default=FALSE); should a blank line be added after.}
}
\value{
NULL, only prints the log
}
\description{
Logging (printing) the results of test cases
}
\note{
Internal function only for convenience
}
\examples{
testPassed <- TRUE
testFailed <- FALSE
\dontrun{
.log('testing something', testPassed)
#testing something...OK
.log('testing other stuff', testFailed, spaceLine=TRUE)
#testing other stuff...FAIL
#
.log('testing more', testPassed, " ", TRUE)
#testing more OK
}
}
\keyword{internal}
