% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils-general.R
\name{.format}
\alias{.format}
\alias{.formatQuote}
\alias{.formatComma}
\alias{.formatParams}
\alias{.formatData}
\alias{.formatLog}
\alias{.formatO}
\title{Format objects for error logging}
\usage{
.formatQuote(v)

.formatComma(v)

.formatParams(v, con = "and")

.formatData(v)

.formatLog(v, fname = c())

.formatO(v, fname)
}
\arguments{
\item{v}{character vector; just some strings}

\item{fname}{character; function name}
}
\value{
character
}
\description{
Format objects for error logging
}
\section{Functions}{
\itemize{
\item \code{.formatQuote()}: add quotes to the vector elements: \code{"<v[i]>"}

\item \code{.formatComma()}: add commas between the vector elements: \verb{<v[1]>, <v[2]>, <v[3]>}

\item \code{.formatParams()}: format the vector: \verb{"<v[1]>", "<v[2]>" and "<v[3]>"}

\item \code{.formatData()}: format the vector: \verb{<v[1]>$<v[2]>$<v[3]>}

\item \code{.formatLog()}: format the vector: \verb{"<v[1]>", "<v[2]>" and "<v[3]>" (in <fname>)}

\item \code{.formatO()}: format a object name with its calling function

}}
\note{
Internal function only for convenience
}
\examples{
\dontrun{
v <- c("one", "two", "three")
fname <- "foo"

.formatQuote(v)
#[1] "\"one\""   "\"two\""   "\"three\""

.formatComma(v)
#[1] "one, two, three"

.formatParams(v)
#[1] "\"one\", \"two\" and \"three\""

.formatData(v)
#[1] "one$two$three"

.formatLog(v)
#[1] "\"one\", \"two\" and \"three\""

.formatLog(v, fname)
#[1] "\"one\", \"two\" and \"three\" (in foo)"

.formatO(.formatLog(v), fname)
#[1] "\"\"one\", \"two\" and \"three\"\" (foo)"
}
}
\keyword{internal}
