% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils-general.R
\name{.createCyVpPorD}
\alias{.createCyVpPorD}
\title{Helper to create structure for classes CyVisualPropertyProperties and CyVisualPropertyDependencies}
\usage{
.createCyVpPorD(name = NULL, value, .log = "")
}
\arguments{
\item{name}{character, optional; name of the properties}

\item{value}{character or named character; value of the properties}

\item{.log}{character (optional); name of the calling function used in logging}
}
\value{
data.frame
}
\description{
Helper to create structure for classes CyVisualPropertyProperties and CyVisualPropertyDependencies
}
\note{
Internal function only for convenience
}
\examples{
\dontrun{
data1 = c(NODE_BORDER_STROKE="SOLID", NODE_BORDER_WIDTH="1.5")
.createCyVpPorD(value=data1)

key1 = c("NODE_BORDER_STROKE", "NODE_BORDER_WIDTH")
value1 = c("SOLID", "1.5")
.createCyVpPorD(key1, value1)

# Result for either:
#                 name value
# 1 NODE_BORDER_STROKE SOLID
# 2  NODE_BORDER_WIDTH   1.5
}
}
\seealso{
Used in \code{\link{CyVisualPropertyProperties}}, \code{\link{CyVisualPropertyDependencies}} and \code{\link{CyVisualPropertyMappings}}
}
\keyword{internal}
