% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCX-MetaData.R
\name{Meta-data}
\alias{Meta-data}
\alias{updateMetaData}
\alias{updateMetaData.RCX}
\alias{updateMetaData.default}
\title{Update RCX meta-data}
\usage{
updateMetaData(
  x,
  version = NULL,
  consistencyGroup = NULL,
  properties = NULL,
  aspectClasses = getAspectClasses()
)

\method{updateMetaData}{RCX}(
  x,
  version = NULL,
  consistencyGroup = NULL,
  properties = NULL,
  aspectClasses = getAspectClasses()
)

\method{updateMetaData}{default}(
  x,
  version = NULL,
  consistencyGroup = NULL,
  properties = NULL,
  aspectClasses = getAspectClasses()
)
}
\arguments{
\item{x}{\link[=RCX-object]{RCX} object or an aspect of a RCX; its class must be one of the standard RCX aspect classes}

\item{version}{named character (optional); version of the aspect (default:"1.0")}

\item{consistencyGroup}{named numerical (optional); consistency group of the aspect (default:1)}

\item{properties}{named list (optional); properties that need to be fetched or updated independently of aspect data}

\item{aspectClasses}{named character; accession names and aspect classes \link{aspectClasses}}
}
\value{
MetaDataAspect object or \link[=RCX-object]{RCX} object
}
\description{
The meta-data aspect contains meta-data about the aspects in the \link[=RCX-object]{RCX} object.
It can be generated automatically based on the aspects present in a \link[=RCX-object]{RCX} object:
\itemize{
\item for \emph{version} and \emph{consistencyGroup} default values are used
\item \emph{idCounter} is inferred with \code{\link{hasIds}} and \code{\link{maxId}} of an aspect
\item \emph{elementCount} is inferred from \code{\link{countElements}}
\item \emph{properties} is left out by default
}
}
\details{
If \emph{version}, \emph{consistencyGroup} or \emph{properties} should have a different value, they can be set using a named vector
(or named list for \emph{properties}), where the name must be an accession name of that aspect in the \code{\link{RCX-object}}
(e.g. \code{nodes} or \code{cyVisualProperties}).

Besides being a named list by aspect accession name, \emph{properties} must also contain the single key-value pairs as a further named list.
To remove all key-value pairs for one aspect, an empty list can be provided instead of a list with key-value pairs.
To simplify adding of properties to a single aspect, there is the \code{\link{updateMetaDataProperties}} function available.
}
\note{
The meta-data will always be updated automatically, when an aspect is added to or changed in the \link[=RCX-object]{RCX} object.
}
\examples{
## prepare RCX object:
nodes = createNodes(name = c("a","b","c","d","e","f"))
edges = createEdges(source=c(1,2,0,0,0,2), 
                    target=c(2,3,1,2,5,4))
rcx = createRCX(nodes, edges)
cySubNetworks = createCySubNetworks(
  id = c(1,2),
  nodes = list("all", c(1,2,3)),
  edges = list("all", c(0,2))                    
)
rcx = updateCySubNetworks(rcx, cySubNetworks)

## update meta-data manually
rcx = updateMetaData(rcx)

## update meta-data with some values
rcx = updateMetaData(rcx,
                     version=c(edges="2.0"),
                     consistencyGroup=c(nodes=3),
                     properties=list(cySubNetworks=list(some="value",
                                                        another="VALUE"),
                                     edges=list(some="edge",
                                                another="EDGE")))

## remove all properties for edges
rcx = updateMetaData(rcx, properties=list(edges=list()))
}
\seealso{
\code{\link{updateMetaDataProperties}}
}
