% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCX-Cytoscape-VisualProperties.R
\name{CyVisualProperty}
\alias{CyVisualProperty}
\alias{createCyVisualProperty}
\title{Cytoscape visual property (object used in CyVisualProperties aspect)}
\usage{
createCyVisualProperty(
  properties = NULL,
  dependencies = NULL,
  mappings = NULL,
  appliesTo = NULL,
  view = NULL
)
}
\arguments{
\item{properties}{a single or a list of \code{\link{CyVisualPropertyProperties}} object (optional);}

\item{dependencies}{a single or a list of\code{\link{CyVisualPropertyDependencies}} object (optional);}

\item{mappings}{a single or a list of\code{\link{CyVisualPropertyMappings}} object (optional);}

\item{appliesTo}{integer (optional); might refer to the IDs of a \link[=CySubNetworks]{subnetwork} aspect, but CX documantation is unclear}

\item{view}{integer (optional); might refer to the IDs of a \link[=CySubNetworks]{subnetwork} aspect that is a view, but CX documantation is unclear}
}
\value{
\code{\link{CyVisualProperty}} object
}
\description{
This function is used to create Cytoscape visual property objects, that define networks, nodes, edges, and default nodes and edges in a
\code{\link{CyVisualProperties}} aspect.
}
\details{
Cytoscape contributes aspects that organize subnetworks, attribute tables, and visual attributes for use by its own layout and
analysis tools. Furthermore are the aspects used in web-based visualizations like within the NDEx platform.

The visual properties aspect is the only aspect (\code{\link{CyVisualProperties}}) with a complex structure. It is composed of several sub-property classes and
consists of \code{\link{CyVisualProperty}} objects, that belong to, or more precisely describe one of the following network elements:
\emph{network}, \emph{nodes}, \emph{edges}, \emph{defaultNodes} or \emph{defaultEdges}.

A single visual property (i.e. \code{\link{CyVisualProperty}} object) organizes the information as \emph{properties}, \emph{dependencies} and \emph{mappings},
as well as the single values \emph{appliesTo} and \emph{view}, that define the subnetwork or view to which the IDs apply.

Properties are \code{\link{CyVisualPropertyProperties}} objects, that hold information like
\code{"NODE_FILL_COLOR" : "#26CCC9"} or \code{"NODE_LABEL_TRANSPARENCY" : "255"} in a key-value like manner.

Dependencies are \code{\link{CyVisualPropertyDependencies}} objects, that hold information
about dependencies between visual properties.
Currently there are only three dependencies supported:
\itemize{
\item Lock Node with and height: \code{nodeSizeLocked = "false"}
\item Fit Custom Graphics to node: \code{nodeCustomGraphicsSizeSync = "true"}
\item Edge color to arrows: \code{arrowColorMatchesEdge = "false"}
}

Mappings are \code{\link{CyVisualPropertyMappings}} objects, that hold information as a triplet consisting of name, type and definition, like
\code{"NODE_FILL_COLOR" : "DISCRETE" : "COL=molecule_type,T=string,K=0=miRNA,V=0=#FCEC00"},
\verb{"NODE_FILL_COLOR" : "CONTINUOUS" : "COL=gal1RGexp,T=double...} or
\code{"NODE_LABEL" : "PASSTHROUGH" : "COL=COMMON,T=string"}.

For further information about Cytoscape visual properties see the \code{Styles} topic of the official Cytoscape documentation:
\href{http://manual.cytoscape.org/en/stable/Styles.html}{http://manual.cytoscape.org/en/stable/Styles.html}

\subsection{Structure of Cytoscape Visual Properties}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{CyVisualProperties
|---network = CyVisualProperty
|---nodes = CyVisualProperty
|---edges = CyVisualProperty
|---defaultNodes = CyVisualProperty
|---defaultEdges = CyVisualProperty

CyVisualProperty
|---properties = CyVisualPropertyProperties
|   |--name
|   |--value 
|---dependencies = CyVisualPropertyDependencies
|   |--name
|   |--value 
|---mappings = CyVisualPropertyMappings
|   |--name
|   |--type
|   |--definition 
|---appliesTo = <reference to subnetwork id>
|---view = <reference to subnetwork id>
}\if{html}{\out{</div>}}
}
}
\examples{
## Prepare used properties
## Visual property: Properties
vpPropertyNamedValue = c(NODE_BORDER_STROKE="SOLID", 
                         NODE_BORDER_WIDTH="1.5")
vpPropertyP = createCyVisualPropertyProperties(vpPropertyNamedValue)

## Visual property: Dependencies
vpDependencyNamedValue = c(nodeSizeLocked="false", 
                           arrowColorMatchesEdge="true")
vpPropertyD = createCyVisualPropertyDependencies(vpDependencyNamedValue)

## Visual property: Mappings
vpMappingNamedType = c(NODE_FILL_COLOR="CONTINUOUS",
                       EDGE_TARGET_ARROW_SHAPE="DISCRETE")
vpMappingDefinition = c("COL=gal1RGexp,T=double,...",
                        "COL=directed,T=boolean,K=0=true,V=0=ARROW")
vpPropertyM = createCyVisualPropertyMappings(vpMappingNamedType, 
                                             vpMappingDefinition)

## Create visual property object 
createCyVisualProperty(properties=vpPropertyP, 
                       dependencies=vpPropertyD, 
                       mappings=vpPropertyM)

## Create visual property object with different subnetworks
createCyVisualProperty(properties=list(vpPropertyP, 
                                       vpPropertyP), 
                       dependencies=list(vpPropertyD,
                                         NA),
                       mappings=list(NA,
                                     vpPropertyM),
                       appliesTo = c(NA,
                                     1),
                       view = c(1,
                                NA))
}
\seealso{
\code{\link{updateCyVisualProperty}}, \code{\link{updateCyVisualProperties}}
}
