% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_analysis_functions.R
\name{summarizeQueryRegionsMulti}
\alias{summarizeQueryRegionsMulti}
\title{summarizeQueryRegionsMulti}
\usage{
summarizeQueryRegionsMulti(queryRegionsList, txdbFeatures, nodeN = 1)
}
\arguments{
\item{queryRegionsList}{GRangesList object imported from multiple BED files
using \code{importBedFiles} function}

\item{txdbFeatures}{List of GRanges objects - outputs of 
\code{getTxdbFeaturesFromGRanges} and \code{getTxdbFeatures} functions}

\item{nodeN}{Positive integer value that denotes the number of cpus to use
for parallel processing (default: 1)}
}
\value{
A list consisting of two data.frame objects: one for raw overlap 
  counts and one for percentage of overlap counts (raw overlap counts divided
  by the number of query regions in the corresponding BED file)
}
\description{
This function is a wrapper function to run RCAS::summarizeQueryRegions 
multiple times, which is useful to get a matrix of overlap counts between a 
list of BED files with a txdbFeatures extracted from GTF file
}
\examples{
data(gff)
data(queryRegions)
queryRegionsList <- GenomicRanges::GRangesList(queryRegions, queryRegions)
names(queryRegionsList) <- c('q1', 'q2')
txdbFeatures <- getTxdbFeaturesFromGRanges(gffData = gff)
summaryMatrix <- summarizeQueryRegionsMulti(queryRegionsList = queryRegionsList,
                                 txdbFeatures = txdbFeatures)

}
