% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_functions.R
\name{getTargetedGenesTable}
\alias{getTargetedGenesTable}
\title{getTargetedGenesTable}
\usage{
getTargetedGenesTable(queryRegions, txdbFeatures)
}
\arguments{
\item{queryRegions}{GRanges object containing coordinates of input query
regions imported by the \code{\link{importBed}} function}

\item{txdbFeatures}{A list of GRanges objects where each GRanges object
corresponds to the genomic coordinates of gene features such as promoters,
introns, exons, 5'/3' UTRs and whole transcripts.
This list of GRanges objects are obtained by the function
\code{\link{getTxdbFeaturesFromGRanges}} or \code{\link{getTxdbFeatures}}.}
}
\value{
A data.frame object where rows correspond to genes and columns
  correspond to gene features
}
\description{
This function provides a list of genes which are targeted by query regions
and their corresponding numbers from an input BED file. Then, the hits are
categorized by the gene features such as promoters, introns, exons,
5'/3' UTRs and whole transcripts.
}
\examples{
data(gff)
data(queryRegions)
txdbFeatures <- getTxdbFeaturesFromGRanges(gffData = gff)
featuresTable <- getTargetedGenesTable(queryRegions = queryRegions,
                                       txdbFeatures = txdbFeatures)

#or
\dontrun{
txdb <- txdbmaker::makeTxDbFromGRanges(gff)
txdbFeatures <- getTxdbFeatures(txdb)
featuresTable <- getTargetedGenesTable(queryRegions = queryRegions,
                                       txdbFeatures = txdbFeatures)
                                       }
}
