% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qProject-class.R
\docType{class}
\name{qProject-class}
\alias{qProject-class}
\alias{show,qProject-method}
\alias{[,qProject,ANY,missing,missing-method}
\alias{alignments,qProject-method}
\alias{alignments}
\alias{auxiliaries,qProject-method}
\alias{auxiliaries}
\alias{genome,qProject-method}
\alias{length,qProject-method}
\alias{qProject}
\alias{class:qProject}
\title{qProject objects}
\description{
The qProject class is a container for the meta-data (e.g. sample
names, paths and names of sequence and alignment files) associated
with a high-throughput sequencing experiment analyzed with \code{QuasR}.
}
\details{
The qProject class is returned by \link{qAlign} and stores all
information on a high-throughput sequencing experiment analyzed with
\code{QuasR}. qProject objects can be conveniently passed to
\sQuote{q}-functions (function name starting with the letter
\sQuote{q}). The information is stored in the following slots:
\describe{
  \item{\code{reads}}{a 'data.frame' with sequence read files.}
  \item{\code{reads_md5subsum}}{a 'data.frame' with fingerprints for
  sequence read files.}
  \item{\code{alignments}}{a 'data.frame' with alignment files.}
  \item{\code{samplesFormat}}{a 'character(1)' specifying the format
  of input files.}
  \item{\code{genome}}{a 'character(1)' specifying the reference genome.}
  \item{\code{genomeFormat}}{a 'character(1)' specifying the format of
  the reference genome.}
  \item{\code{aux}}{a 'data.frame' with auxiliary reference sequence files.}
  \item{\code{auxAlignments}}{a 'data.frame' with alignment files for
  auxiliary reference sequence files.}
  \item{\code{aligner}}{a 'character(1)' specifying the aligner.}
  \item{\code{maxHits}}{a 'numeric(1)' specifying the maximum number
  of alignments per sequence.}
  \item{\code{paired}}{a 'character(1)' specifying the paired-type;
  one of "no", "fr", "rf", "ff".}
  \item{\code{splicedAlignment}}{a 'logical(1)'; \code{TRUE} when
  performing spliced-alignments.}
  \item{\code{snpFile}}{a 'character(1)' with a file name containing
  SNP information.}
  \item{\code{bisulfite}}{a 'character(1)' defining the bisulfite
  type; one of "no", "dir", "undir".}
  \item{\code{alignmentParameter}}{a 'character(1)' with aligner
  command line parameters.}
  \item{\code{projectName}}{a 'character(1)' with the project name.}
  \item{\code{alignmentsDir}}{a 'character(1)' with the directory to
  be used to store alignment files.}
  \item{\code{lib.loc}}{a 'character(1)' with the library directory to
  use for installing of alignment index packages.}
  \item{\code{cacheDir}}{a 'character(1)' with a directory to use for
  temporary files.}
  \item{\code{alnModeID}}{a 'character(1)' used internally to indicate
  the alignment mode.}
}
}
\section{Accessors}{

In the following code snippets, \code{x} is a qProject object.
\describe{
  \item{\code{length(x)}}{: Gets the number of input files.}
  \item{\code{genome(x)}}{: Gets the reference genome as a 'character(1)'.
  The type of genome is stored as an attribute in
  \code{attr(genome(x),"genomeFormat")}: "BSgenome" indicates that
  \code{genome(x)} refers to the name of a BSgenome package, "file"
  indicates that it contains the path and filename of a genome in
  FASTA format.}
  \item{\code{auxiliaries(x)}}{: Gets a \code{data.frame} with auxiliary
  target sequences, with one row per auxiliary target, and columns
  "FileName" and "AuxName".}
  \item{\code{alignments(x)}}{: Gets a list with two elements "genome" and
  "aux". \code{alignments(x)$genome} contains a \code{data.frame}
  with \code{length(x)} rows and the columns "FileName" (containing
  the path to bam files with genomic alignments) and
  "SampleName". \code{alignments(x)$aux} contains a
  \code{data.frame} with one row per auxiliary target sequence (with
  auxiliary names as row names), and \code{length(x)} columns.}
}
}

\section{Subsetting}{

In the following code snippets, \code{x} is a qProject object.
\describe{
  \item{\code{x[i]}}{: Get \code{qProject} object instance with \code{i}
  input files, where \code{i} can be an NA-free logical, numeric, or
  character vector.}
}
}

\examples{
# copy example data to current working directory
file.copy(system.file(package="QuasR", "extdata"), ".", recursive=TRUE)

# create alignments
sampleFile <- "extdata/samples_chip_single.txt"
genomeFile <- "extdata/hg19sub.fa"
auxFile <- "extdata/auxiliaries.txt"

proj <- qAlign(sampleFile, genomeFile, auxiliaryFile=auxFile)
proj

# alignment statistics using a qProject
alignmentStats(proj)

# alignment statistics using bam files
alignmentStats(alignments(proj)$genome$FileName)
alignmentStats(unlist(alignments(proj)$aux))

}
\seealso{
\link{qAlign}
}
\author{
Anita Lerch, Dimos Gaidatzis and Michael Stadler
}
