% Generated by roxygen2: do not edit by hand
% Please edit documentation in src/rcpp_qubic.cpp
\name{qudiscretize}
\alias{qdiscretize}
\alias{qudiscretize}
\title{Create a qualitative discrete matrix for a given gene expression matrix}
\usage{
qudiscretize(x, r = 1L, q = 0.06)
}
\arguments{
\item{x}{the input data matrix, which could be the normalized gene expression matrix or its qualitative representation from Qdiscretization or other discretization ways.
(for example: a qualitative representation of gene expression data) \cr
For \code{BCQU()}, the data matrix should be real \cr
For \code{BCQUD()}, the data matrix should be discretized as integer.
Zeros in the matrix will be treated as non-relevant value.}

\item{r}{Affect the granularity of the biclusters. The range of possible ranks.
A user can start with a small value of \code{r}
(the default value is \code{1} so the corresponding data matrix consists of values '\code{1}', '\code{-1}' and '\code{0}'),
evaluate the results, and then use larger values
(should not be larger than half of the number of the columns) to look for fine structures within the identified biclusters.}

\item{q}{Affect the granularity of the biclusters. The percentage of the regulating conditions for each gene.
The choice of \code{q}'s value depends on the specific application goals;
that is if the goal is to find genes that are responsive to local regulators,
we should use a relatively small \emph{q}-value; otherwise we may want to consider larger \emph{q}-values.
The default value of \code{q} is \code{0.06} in QUBIC
(this value is selected based on the optimal biclustering results on simulated data).}
}
\value{
A qualitative discrete matrix
}
\description{
\code{qudiscretize} delivers a discrete matrix. It is useful if we just want to get a discretized matrix.
}
\details{
\code{qudiscretize} convert a given gene expression matrix to a discrete matrix.
It's implimented in C++, providing a increase in speed over the C equivalent.
}
\examples{
# Qualitative discretize yeast microarray data
data(BicatYeast)
qudiscretize(BicatYeast[1:7, 1:5])

}
\seealso{
\code{\link{QUBIC}} \code{\link{discretize}}
}

