% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{computeweight_mean}
\alias{computeweight_mean}
\title{Compute weights for mean shift analysis}
\usage{
computeweight_mean(beta, mu, pi, n, k)
}
\arguments{
\item{beta}{Dispersion parameter of the negative binomial component. Must be
strictly positive.}

\item{mu}{Mean of the uninflated negative binomial distribution. Should be
non-negative.}

\item{pi}{Probability of zeros due to zero inflation.}

\item{n}{Sample size of \eqn{y}}

\item{k}{Sample size of \eqn{x}}
}
\value{
A list containing a weight vector (\verb{$weight}) and
estimated variance (\verb{$var}) useful for constructing test statistics.
}
\description{
Given the value of the estimated parameters for zero-inflated negative
binomial distribution (\eqn{\beta}, \eqn{\mu}, \eqn{\pi}),the sample sizes
\eqn{n} and \eqn{k} (by default \eqn{n\geqslant k}), this function computes
weights that target changes in the mean parameter of the zero-inflated
negative binomial model.
}
\details{
The function generates a vector of weights and an estimated variance that
are used to construct test statistics. The weight vector is computed by
considering how each potential count value from the combined distribution
contributes to the expected shift in mean, considering both inflated and
uninflated components.
}
\examples{

computeweight_mean(beta = 5, mu = 40, pi = 0.1, n = 100, k = 60)

}
