% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QRscore.R
\name{QRscore_Flex}
\alias{QRscore_Flex}
\title{Flexible Non-Parametric One- and Two-Sample Tests (Native R version)}
\usage{
QRscore_Flex(
  x,
  y = NULL,
  p = 1,
  wList,
  alternative = "two.sided",
  approx = "resample",
  type = "unbiased",
  n_mom = NULL,
  resamp_number = 5000
)
}
\arguments{
\item{x}{First sample}

\item{y}{Second sample}

\item{p}{Exponent value in defining test statistic (must be integer)}

\item{wList}{Vector of weights. It should have length equal to \eqn{x} when
\eqn{y} is \code{NULL}, and one more than the length of \eqn{x} when \eqn{y} is
not \code{NULL}}

\item{alternative}{How p-value should be computed; i.e., a character
specifying the alternative hypothesis, must be one of "\code{two.sided}",
"\code{greater}" or "\code{less}"}

\item{approx}{Which approximation method to use (choose "\code{resample}",
"\code{asymptotic}")}

\item{type}{If using resampling approximation, either an unbiased estimate of
("\code{unbiased}", default), or valid, but biased estimate of, ("\code{valid}")
p-value (see Hemerik and Goeman, 2018), or both ("\code{both}").
Default is "\code{unbiased}".}

\item{n_mom}{The number of moments to accompany the approximation
(recommended 200, if not at least 100)}

\item{resamp_number}{Number of \eqn{k}-compositions of \eqn{n} or simplex
vectors in \eqn{[0,1]^k}  to draw}
}
\value{
Returns the p-value.
}
\description{
Given data consisting of either a single sample
\eqn{\boldsymbol{x}=(x_1,\ldots,x_k)},
or two samples \eqn{\boldsymbol{x}=(x_1,\ldots,x_k)} and
\eqn{\boldsymbol{y}=(y_1,\ldots,y_n)},
this function uses summary statistics computed on weighted linear
combinations of powers of the spacing statistics
\eqn{S_k} (former) or \eqn{S_{n,k}} (latter).
}
\details{
More precisely, this function does the following:

For a single sample \eqn{x}, the function tests for uniformity of its
entries. When \eqn{p=2} and a particular choice of \eqn{\boldsymbol{w}} is
specified, we recover Greenwood's test.

For two samples, the function tests the null of \eqn{\boldsymbol{x}} and
\eqn{\boldsymbol{y}} being drawn from the same distribution
(i.e., stochastic equality), against flexible alternatives that correspond
to specific choices of the test statistic parameters, \eqn{\boldsymbol{w}}
(weight vector) and \eqn{p} (power). These parameters not only determine the
test statistic \eqn{||S_k||_{p,\boldsymbol{w}}^p=\sum_{j=1}^k w_iS_{k}[j]^p}
(analogously defined for \eqn{||S_{n,k}||_{p,\boldsymbol{w}}^p}), but also
encode alternative hypotheses ranging from different populational means
(i.e., \eqn{\mu_x \neq \mu_y}), different populational spreads
(i.e., \eqn{\sigma^2_x \neq \sigma^2_y}), etc.

Additional tuning parameters include:
(1) choice of p-value computation (one- or two-sided);
(2) approximation method
(3) number of moments accompanying the approximation chosen if using
moment-based approximation (recommended 200, typically at least 100); and
(4) in case of two samples, whether the user prefers to use exact discrete
moments (more accurate but slower) or to use continuous approximations of the
discrete moments (less accurate but faster).

Currently, only resampling and Gaussian asymptotics are supported.
Both are efficient and well-calibrated. For \eqn{n\geqslant 100} and
\eqn{k\geqslant 50} such that \eqn{\frac{k}{n}\geqslant 0.001},
function automatically uses Gaussian approximation to the null.

Dependencies: functions in \code{utils.R}
}
\examples{

set.seed(1)
# One-sample examples
QRscore_Flex(
    x = abs(rnorm(10)), p = 2, wList = rep(1, 10),
    alternative = "two.sided", approx = "resample"
)

# Two-sample examples
QRscore_Flex(
    x = abs(rnorm(30)), y = abs(rnorm(100)), p = 2,
    wList = rep(1, 31), alternative = "two.sided",
    approx = "resample", resamp_number = 5000
)

QRscore_Flex(
    x = abs(rnorm(100)), y = abs(rnorm(100)), p = 1,
    wList = 0:100, alternative = "two.sided",
    approx = "asymptotic"
)
}
