% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetBy-methods.R
\name{subsetByFeature}
\alias{subsetByFeature}
\alias{subsetByFeature,QFeatures,character-method}
\title{Subset by feature name}
\arguments{
\item{x}{An instance of class \link{QFeatures}.}

\item{y}{A \code{character} of feature names present in an assay in \code{x}.}

\item{...}{Additional parameters. Ignored.}
}
\value{
An new instance of class \link{QFeatures} containing relevant
assays and features.
}
\description{
This function will find the assays and features that match
directly (by name) or indirectly (through aggregation) the feature
name.

The \code{subsetByFeature} function will first identify the assay that
contains the feature(s) \code{i} and filter the rows matching these
feature names exactly. It will then find, in the other assays, the
features that produces \code{i} through aggregation with the
\code{aggregateQFeatures} function.

See \link{QFeatures} for an example.
}
\examples{
example(aggregateFeatures)

## Retrieve protein 'ProtA' and its 2 peptides and 6 PSMs
feat1["ProtA", , ]
}
