% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QFeatures-class.R
\name{QFeatures}
\alias{QFeatures}
\alias{QFeatures-class}
\alias{class:QFeatures}
\alias{addAssay}
\alias{dims,QFeatures-method}
\alias{show,QFeatures-method}
\alias{[,QFeatures,ANY,ANY,ANY-method}
\alias{[,QFeatures,character,ANY,ANY-method}
\alias{rowDataNames}
\alias{selectRowData}
\alias{plot.QFeatures}
\alias{coerce-QFeatures}
\alias{coerce,MultiAssayExperiment,QFeatures-method}
\alias{c,QFeatures-method}
\alias{nrows,QFeatures-method}
\alias{ncols,QFeatures-method}
\alias{rowData,QFeatures-method}
\alias{rowData<-,QFeatures,DataFrameList-method}
\alias{rowData<-,QFeatures,ANY-method}
\alias{rbindRowData}
\alias{names<-,QFeatures,character-method}
\alias{removeAssay}
\alias{replaceAssay}
\alias{[[<-,QFeatures,ANY,ANY-method}
\alias{updateObject,QFeatures-method}
\alias{dropEmptyAssays}
\title{Quantitative MS QFeatures}
\usage{
QFeatures(..., assayLinks = NULL)

\S4method{show}{QFeatures}(object)

\method{plot}{QFeatures}(x, interactive = FALSE, ...)

\S4method{[}{QFeatures,ANY,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{QFeatures,character,ANY,ANY}(x, i, j, k, ..., drop = TRUE)

\S4method{c}{QFeatures}(x, ...)

\S4method{dims}{QFeatures}(x, use.names = TRUE)

\S4method{nrows}{QFeatures}(x, use.names = TRUE)

\S4method{ncols}{QFeatures}(x, use.names = TRUE)

\S4method{rowData}{QFeatures}(x, use.names = TRUE, ...)

\S4method{rowData}{QFeatures,DataFrameList}(x) <- value

\S4method{rowData}{QFeatures,ANY}(x) <- value

rbindRowData(object, i)

selectRowData(x, rowvars)

rowDataNames(x)

\S4method{names}{QFeatures,character}(x) <- value

addAssay(x, y, name, assayLinks)

removeAssay(x, i)

replaceAssay(x, y, i)

\S4method{[[}{QFeatures,ANY,ANY}(x, i, j, ...) <- value

\S4method{updateObject}{QFeatures}(object, ..., verbose = FALSE)

dropEmptyAssays(object, dims = 1:2)
}
\arguments{
\item{...}{See \code{MultiAssayExperiment} for details. For \code{plot},
further arguments passed to \code{igraph::plot.igraph}.}

\item{assayLinks}{An optional \link{AssayLinks}.}

\item{object}{An instance of class \link{QFeatures}.}

\item{x}{An instance of class \link{QFeatures}.}

\item{interactive}{A \code{logical(1)}. If \code{TRUE}, an interactive graph
is generated using \code{plotly}. Else, a static plot using \code{igraph}
is generated. We recommend interactive exploration when the
\code{QFeatures} object contains more than 50 assays.}

\item{i}{An indexing vector. See the corresponding section in the
documentation for more details.}

\item{j}{\code{character()}, \code{logical()}, or \code{numeric()} vector for
subsetting by \code{colData} rows.}

\item{drop}{logical (default \code{TRUE}) whether to drop empty assay
elements in the \code{ExperimentList}.}

\item{k}{\code{character()}, \code{logical()}, or \code{numeric()} vector for
subsetting by assays}

\item{use.names}{A \code{logical(1)} indicating whether the rownames of
each assay should be propagated to the corresponding \code{rowData}.}

\item{value}{The values to use as a replacement. See the
corresponding section in the documentation for more details.}

\item{rowvars}{A \code{character()} with the names of the \code{rowData}
variables (columns) to retain in any assay.}

\item{y}{An object that inherits from \code{SummarizedExperiment} or a
\emph{named} list of assays. When \code{y} is a list, each element must
inherit from a \code{SummarizedExperiment} and the names of the
list are used as the names of the assays to add. Hence, the
list names must be unique and cannot overlap with the names of
the assays already present in \code{x}.}

\item{name}{A \code{character(1)} naming the single assay. Ignored if
\code{y} is a list of assays.}

\item{verbose}{logical (default FALSE) whether to print extra messages}

\item{dims}{\code{numeric()} that defines the dimensions to consider to
drop empty assays. 1 for rows (i.e. assays without any
features) and 2 for columns (i.e. assays without any
samples). Default is \code{1:2}. Any value other that 1 and/or 2
will trigger an error.}
}
\description{
Conceptually, a \code{QFeatures} object holds a set of \emph{assays}, each
composed of a \code{matrix} (or \code{array}) containing quantitative data
and row annotations (meta-data).  The number and the names of the
columns (samples) must always be the same across the assays, but
the number and the names of the rows (features) can vary. The
assays are typically defined as \code{SummarizedExperiment} objects. In
addition, a \code{QFeatures} object also uses a single \code{DataFrame} to
annotate the samples (columns) represented in all the matrices.

The \code{QFeatures} class extends the
\link[MultiAssayExperiment:MultiAssayExperiment]{MultiAssayExperiment::MultiAssayExperiment} and inherits all
the functionality of the
\link[MultiAssayExperiment:MultiAssayExperiment]{MultiAssayExperiment::MultiAssayExperiment} class.

A typical use case for such \code{QFeatures} object is to represent
quantitative proteomics (or metabolomics) data, where different
assays represent quantitation data at the PSM (the main assay),
peptide and protein level, and where peptide values are computed
from the PSM data, and the protein-level data is calculated based
on the peptide-level values. The largest assay (the one with the
highest number of features, PSMs in the example above) is
considered the main assay.

The recommended way to create \code{QFeatures} objects is the use the
\code{\link[=readQFeatures]{readQFeatures()}} function, that creates an instance from tabular
data. The \code{QFeatures} constructor can be used to create objects
from their bare parts.  It is the user's responsability to make
sure that these match the class validity requirements.
}
\section{Constructors}{

\itemize{
\item \code{QFeatures(..., assayLinks)} allows the manual construction of
objects. It is the user's responsability to make sure these
comply. The arguments in \code{...} are those documented in
\code{\link[MultiAssayExperiment:MultiAssayExperiment]{MultiAssayExperiment::MultiAssayExperiment()}}. For details
about \code{assayLinks}, see \link{AssayLinks}. An example is shown below.
\item The \code{\link[=readQFeatures]{readQFeatures()}} function constructs a \code{QFeatures} object
from text-based spreadsheet or a \code{data.frame} used to generate
an assay. See the function manual page for details and an
example.
}
}

\section{Accessors}{

\itemize{
\item The \code{QFeatures} class extends the
\link[MultiAssayExperiment:MultiAssayExperiment]{MultiAssayExperiment::MultiAssayExperiment} class and inherits
all its accessors and replacement methods.
\item The \code{rowData} method returns a \code{DataFrameList} containing the
\code{rowData} for each assay of the \code{QFeatures} object. On the other
hand, \code{rowData} can be modified using \code{rowData(x) <- value},
where \code{value} is a list of tables that can be coerced to \code{DFrame}
tables. The names of \code{value} point to the assays for
which the \code{rowData} must be replaced. The column names of each
table are used to replace the data in the existing \code{rowData}. If
the column name does not exist, a new column is added to the
\code{rowData}.
\item The \code{rbindRowData} functions returns a \code{DFrame} table that
contains the row binded \code{rowData} tables from the selected
assays. In this context, \code{i} is a \code{character()}, \code{integer()} or
\code{logical()} object for subsetting assays. Only rowData variables
that are common to all assays are kept.
\item The \code{rowDataNames} accessor returns a list with the \code{rowData}
variable names.
\item The \code{\link[=longForm]{longForm()}} accessor takes a \code{QFeatures} instance and returns it in a
long \emph{tidy} \code{DataFrame}, where each quantitative value is reported on a
separate line.
}
}

\section{Adding, removing and replacing assays}{

\itemize{
\item The \code{\link[=aggregateFeatures]{aggregateFeatures()}} function creates a new assay by
aggregating features of an existing assay.
\item \code{addAssay(x, y, name, assayLinks)}: Adds one or more
new assay(s) \code{y} to the \code{QFeatures} instance \code{x}. \code{name}
is a \code{character(1)} naming the assay if only one assay is
provided, and is ignored if \code{y} is a list of assays. \code{assayLinks}
is an optional \link{AssayLinks}. The \code{colData(y)} is
automatically added to \code{colData(x)} by matching sample
names, that is \code{colnames(y)}. If the samples are not present in
\code{x}, the rows of \code{colData(x)} are extended to account for the
new samples. Be aware that conflicting information between the
\code{colData(y)} and the \code{colData(x)} will result in an
error.
\item \code{removeAssay(x, i)}: Removes one or more assay(s) from the
\code{QFeatures} instance \code{x}. In this context, \code{i} is a \code{character()},
\code{integer()} or \code{logical()} that indicates which assay(s) to
remove.
\item \code{replaceAssay(x, y, i)}: Replaces one or more
assay(s) from the \code{QFeatures} instance \code{x}. In this context, \code{i}
is a \code{character()}, \code{integer()} or \code{logical()} that indicates
which assay(s) to replace. The \code{AssayLinks} from or to
any replaced assays are automatically removed, unless the
replacement has the same dimension names (columns and row, order
agnostic). Be aware that conflicting information between
\code{colData(y)} and \code{colData(x)} will result in an error.
\item \code{x[[i]] <- value}: a generic method for adding (when \code{i} is not
in \code{names(x)}), removing (when \code{value} is null) or replacing (when
\code{i} is in \code{names(x)}). Note that the arguments \code{j} and \code{...} from
the S4 replacement method signature are not allowed.
}
}

\section{Subsetting}{

\itemize{
\item QFeatures object can be subset using the \code{x[i, j, k, drop = TRUE]}
paradigm. In this context, \code{i} is a \code{character()}, \code{integer()},
\code{logical()} or \code{GRanges()} object for subsetting by rows. See
the argument descriptions for details on the remaining arguments.
\item The \code{\link[=subsetByFeature]{subsetByFeature()}} function can be used to subset a
\code{QFeatures} object using one or multiple feature names that will
be matched across different assays, taking the aggregation
relation between assays.
\item The \code{selectRowData(x, rowvars)} function can be used to
select a limited number of \code{rowData} columns of interest named
in \code{rowvars} in the \code{x} instance of class \code{QFeatures}. All other
variables than \code{rowvars} will be dropped. In case an element in
\code{rowvars} isn't found in any \code{rowData} variable, a message is
printed.
\item The \code{dropEmptyAssays(object, dims)} function removes empty
assays from a \code{QFeatures}. Empty assays are defined as having 0
rows and/or 0 columns, as defined by the \code{dims} argument.
}
}

\examples{
## ------------------------
## An empty QFeatures object
## ------------------------

QFeatures()

## -----------------------------------
## Creating a QFeatures object manually
## -----------------------------------

## two assays (matrices) with matching column names
m1 <- matrix(1:40, ncol = 4)
m2 <- matrix(1:16, ncol = 4)
sample_names <- paste0("S", 1:4)
colnames(m1) <- colnames(m2) <- sample_names
rownames(m1) <- letters[1:10]
rownames(m2) <- letters[1:4]

## two corresponding feature metadata with appropriate row names
df1 <- DataFrame(Fa = 1:10, Fb = letters[1:10],
                 row.names = rownames(m1))
df2 <- DataFrame(row.names = rownames(m2))

(se1 <- SummarizedExperiment(m1, df1))
(se2 <- SummarizedExperiment(m2, df2))

## Sample annotation (colData)
cd <- DataFrame(Var1 = rnorm(4),
                Var2 = LETTERS[1:4],
                row.names = sample_names)

el <- list(assay1 = se1, assay2 = se2)
fts1 <- QFeatures(el, colData = cd)
fts1
fts1[[1]]
fts1[["assay1"]]

## Rename assay
names(fts1) <- c("se1", "se2")

## Add an assay
fts1 <- addAssay(fts1, se1[1:2, ], name = "se3")

## Get the assays feature metadata
rowData(fts1)

## Keep only the Fa variable
selectRowData(fts1, rowvars = "Fa")

## -----------------------------------
## See ?readQFeatures to create a
## QFeatures object from a data.frame
## or spreadsheet.
## -----------------------------------

}
\seealso{
\itemize{
\item The \code{\link[=readQFeatures]{readQFeatures()}} constructor and the \code{\link[=aggregateFeatures]{aggregateFeatures()}}
function. The \emph{QFeatures} vignette provides an extended example.
\item The \link{QFeatures-filtering} manual page demonstrates how to filter
features based on their rowData.
\item The \link{missing-data} manual page to manage missing values in
\code{QFeatures} objects.
\item The \link{QFeatures-processing} and \code{\link[=aggregateFeatures]{aggregateFeatures()}} manual pages
and \emph{Processing} vignette describe common quantitative data
processing methods using in quantitative proteomics.
}
}
\author{
Laurent Gatto
}
