% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EigenMS.R
\name{sva.id}
\alias{sva.id}
\title{Surrogate Variable Analysis}
\usage{
sva.id(dat, n.u.treatment, lm.fm, B = 500, sv.sig = 0.05)
}
\arguments{
\item{dat}{number of peptides/genes x number of samples
matrix of expression data with no missing values}

\item{n.u.treatment}{number of treatment groups}

\item{lm.fm}{formular for treatment to be use on the right side of the call
to stats::lm() as generated by makeLMFormula()}

\item{B}{The number of null iterations to perform}

\item{sv.sig}{The significance cutoff for the surrogate variables}
}
\value{
A data structure with the following values:
\describe{
  \item{n.sv}{Number of significant surrogate variables}
  \item{p.sv}{Significance for the returned surrogate variables}
}
}
\description{
Surrogate Variable Analysis function used internatlly by
eig_norm1 and eig_norm2
Here we incorporate the model matrix from EigenMS
normalization to find the significant
trends in the matrix of residuals.
}
