% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EigenMS.R
\name{eig_norm1}
\alias{eig_norm1}
\title{Identify bias trends}
\usage{
eig_norm1(m, treatment, prot.info, write_to_file = "")
}
\arguments{
\item{m}{number of peptides x number of samples matrix of log-transformed
expression data, metadata not included in this matrix}

\item{treatment}{either a single factor indicating the treatment group of
each sample i.e. [1 1 1 1 2 2 2 2...]
or a data frame of factors, eg:
 treatment= data.frame(cbind(data.frame(Group), data.frame(Time))}

\item{prot.info}{2+ colum data frame, pepID, prID columns IN THAT ORDER.
IMPORTANT: pepIDs must be unique identifiers and will be used
as Row Names
If normalizing non-proteomics data, create a column such as:
paste('ID_',seq_len(num_rows), sep='')
Same can be dome for ProtIDs, these are not used for
normalization but are kept for future analyses}

\item{write_to_file}{if a string is passed in, 'complete' peptides
(peptides with NO missing observations)
will be written to that file name}
}
\value{
A structure with multiple components
\describe{
  \item{m, treatment, prot.info, grp}{initial parameters passed into the
       function, returned for future reference}
  \item{my.svd}{matrices produced by SVD}
  \item{pres}{matrix of peptides that can be normalized, i.e. have enough
              observations for ANOVA}
  \item{n.treatment}{number of factors passed in}
  \item{n.u.treatment}{number of unique treatment facotr combinations, eg:
                  Factor A: a a a a c c c c
                  Factor B: 1 1 2 2 1 1 2 2
                  then:  n.treatment = 2; n.u.treatment = 4}
  \item{h.c}{number of bias trends identified}
  \item{present}{names/IDs of peptides in variable 'pres'}
  \item{complete}{complete peptides with no missing values,
                  these were used to compute SVD}
  \item{toplot1}{trends automatically identified in raw data,
                 can be plotted at a later time}
  \item{Tk}{scores for each bias trend, eigenvalues}
  \item{ncompl}{number of complete peptides with no missing observations}
}
}
\description{
First portion of EigenMS: Identify eigentrends attributable to bias, allow
the user to adjust the number (with causion! if desired) before normalizing
with eig_norm2.
Ref: "Normalization of peak intensities in bottom-up MS-based proteomics
      using singular value decomposition" Karpievitch YV, Taverner T, et al.
      2009, Bioinformatics
Ref:  "Metabolomics data normalization with EigenMS"
      Karpievitch YK, Nikolic SB, Wilson R, Sharman JE, Edwards LM 2014,
      PLoS ONE
}
\examples{
data(mm_peptides)
head(mm_peptides)
# different from parameter names as R uses outer name spaces
# if variable is undefined
intsCols = 8:13
metaCols = 1:7 # reusing this variable
m_logInts = make_intencities(mm_peptides, intsCols)  # will reuse the name
m_prot.info = make_meta(mm_peptides, metaCols)
m_logInts = convert_log2(m_logInts)
# 3 samples for CG and 3 for mCG
grps = as.factor(c('CG','CG','CG', 'mCG','mCG','mCG'))

# ATTENTION: SET RANDOM NUMBER GENERATOR SEED FOR REPRODUCIBILITY !!
set.seed(123) # Bias trends are determined via a permutaion, results may
# vary slightly if a different seed is used, such as when set.seed()
# function is not used

mm_m_ints_eig1 = eig_norm1(m=m_logInts,treatment=grps,prot.info=m_prot.info)
mm_m_ints_eig1$h.c # check the number of bias trends detected
mm_m_ints_norm = eig_norm2(rv=mm_m_ints_eig1)
}
