% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllMethods.R
\name{setTxDb}
\alias{setTxDb}
\alias{setTxDb,ProteoDiscography-method}
\title{Change the underlying TxDb of a ProteoDiscography object.}
\usage{
setTxDb(x, TxDb)

\S4method{setTxDb}{ProteoDiscography}(x, TxDb)
}
\arguments{
\item{x}{(ProteoDiscography): ProteoDiscography object.}

\item{TxDb}{(\link[GenomicFeatures]{TxDb}): TxDb object containing the genomic and transcript annotations.}
}
\value{
ProteoDiscography with updated TxDb.
}
\description{
Change the underlying TxDb of a ProteoDiscography object.
}
\examples{

# Import example ProteoDiscography (hg19) and re-link TxDb.
data('ProteoDiscographyExample.hg19', package = 'ProteoDisco')
ProteoDiscographyExample.hg19 <- setTxDb(ProteoDiscographyExample.hg19, TxDb.Hsapiens.UCSC.hg19.knownGene::TxDb.Hsapiens.UCSC.hg19.knownGene)

summary(ProteoDiscographyExample.hg19)

}
