% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllMethods.R
\name{setMutantTranscripts}
\alias{setMutantTranscripts}
\alias{setMutantTranscripts,ProteoDiscography-method}
\alias{mutantTranscripts,ProteoDiscography-method}
\title{Adds mutant transcript sequences to the ProteoDiscography in the appropriate slot}
\usage{
setMutantTranscripts(x, transcripts, slotType)

\S4method{setMutantTranscripts}{ProteoDiscography}(x, transcripts, slotType)

\S4method{mutantTranscripts}{ProteoDiscography}(x)
}
\arguments{
\item{x}{(ProteoDiscography): The ProteoDiscography for which the slot will be edited.}

\item{transcripts}{(DataFrame): Transcripts to be used in the slot.}

\item{slotType}{(character): Implemented slot to be edited.}
}
\value{
{ProteoDiscography} with updated records.
}
\description{
Adds mutant transcript sequences to the ProteoDiscography in the appropriate slot
}
\examples{

# From a ProteoDiscography with imported and incorporated records, take only the first 10 records.
# ProteoDisco::setMutantTranscripts(ProteoDiscography)$genomicVariants[1:10], slotType = 'genomicVariants')
# ProteoDisco::setMutantTranscripts(ProteoDiscography)$spliceJunctions[1:10], slotType = 'spliceJunctions')
# ProteoDisco::setMutantTranscripts(ProteoDiscography)$manualSequences[1:10], slotType = 'manualSequences')

# Import example ProteoDiscography (hg19)
data('ProteoDiscographyExample.hg19', package = 'ProteoDisco')
ProteoDiscographyExample.hg19 <- setTxDb(ProteoDiscographyExample.hg19, TxDb.Hsapiens.UCSC.hg19.knownGene::TxDb.Hsapiens.UCSC.hg19.knownGene)
ProteoDiscographyExample.hg19 <- setGenomicSequences(ProteoDiscographyExample.hg19, BSgenome.Hsapiens.UCSC.hg19::BSgenome.Hsapiens.UCSC.hg19)

# Only keep the first ten records.
ProteoDiscographyExample.hg19 <- ProteoDisco::setMutantTranscripts(
  x = ProteoDiscographyExample.hg19,
  transcripts = ProteoDisco::mutantTranscripts(ProteoDiscographyExample.hg19)$genomicVariants[1:10,],
  slotType = 'genomicVariants'
)

}
