% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_checkReferenceAnchor.R
\name{.checkReferenceAnchor}
\alias{.checkReferenceAnchor}
\title{Checks if mutations and reference genome correspond}
\usage{
.checkReferenceAnchor(
  mutations,
  genomeSeqs,
  ignoreNonMatch = FALSE,
  threads = 1
)
}
\arguments{
\item{mutations}{(\link[VariantAnnotation]{VRanges}): Mutations to incorporate within transcripts.}

\item{genomeSeqs}{(\link[BSgenome]{BSgenome} or \link[Biostrings]{DNAStringSet}): Reference genome sequences.}

\item{ignoreNonMatch}{(logical): Should non-matching reference anchors be ignored? These mutations will be removed.}

\item{threads}{(integer): Number of threads.}
}
\value{
(logical): Returns TRUE/FALSE if per given mutation based on matching position and base with the reference genome.
}
\description{
Overlaps the reference bases and positions with the given genome and check if all positions overlap and reports
non-overlapping mutations.
}
\author{
Job van Riet \email{j.vanriet@erasmusmc.nl}

Wesley van de Geer \email{w.vandegeer@erasmusmc.nl}
}
\concept{methods}
\keyword{methods}
