% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_labels.R
\name{make_labels}
\alias{make_labels}
\title{Make labels for a classifier based on a gold standard}
\usage{
make_labels(gold_standard, dat, node_columns = c(1, 2), protein_groups = NULL)
}
\arguments{
\item{gold_standard}{an adjacency matrix of gold-standard interactions}

\item{dat}{a data frame with interacting proteins in the first two
columns}

\item{node_columns}{a vector of length two, denoting either the indices 
(integer vector) or column names (character vector) of the columns within 
the data frame containing the nodes participating in pairwise interactions;
defaults to the first two columns of the data frame (\code{c(1, 2)})}

\item{protein_groups}{optionally, specify a list linking each protein in the 
first two columns of the input data frame to a protein group}
}
\value{
a vector of the same length as the input dataset, containing 
\code{NA}s for protein pairs not in the gold standard and ones or zeroes
based on the content of the adjacency matrix
}
\description{
Create labels for a classifier for protein pairs in the same order as 
in a dataset that will be used as input to a classifier, in a 
memory-friendly way.
}
\examples{
data(gold_standard)
adj <- adjacency_matrix_from_list(gold_standard)
proteins <- unique(unlist(gold_standard))
dat <- data.frame(protein_A = sample(proteins, 10), 
                  protein_B = sample(proteins, 10))
labels <- make_labels(adj, dat)

}
