% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/podcallMultiplot.R
\name{podcallMultiplot}
\alias{podcallMultiplot}
\title{podcallMultiplot}
\usage{
podcallMultiplot(
  plateData,
  thresholds,
  channel = c("target", "control"),
  colCh = c(1, 2, 3, 4, 5, 6)
)
}
\arguments{
\item{plateData}{A list containing data frames with amplitude values from
selected wells that is to be compared. One data frame per well.}

\item{thresholds}{A vector containing the thresholds for the selected wells}

\item{channel}{What channel to plot,  'target' channel or 'ontrol' channel.}

\item{colCh}{The channel from the instrument to plot. Controls color of plot.}
}
\value{
Faceted scatterplot with line indicating threshold. One facet per
    selected well.
}
\description{
A function that returns faceted scatterplots for multiple wells
    suitable for comparison of wells.
}
\examples{

## Set path to data
path <- system.file("extdata", "Amplitudes/", package="PoDCall")

## Read in data files
data <- importAmplitudeData(path, skipLines=0)
data("thrTable")

## Create plot using threshold from thrTable, see ?thrTable
plot <- podcallMultiplot(plateData=data,
                        thresholds=thrTable[names(data), ],
                        channel="target")

}
