% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_funcs.R
\name{estimate_psi_df}
\alias{estimate_psi_df}
\title{Estimate psi and degrees of freedom}
\usage{
estimate_psi_df(pep.ab.table)
}
\arguments{
\item{pep.ab.table}{The peptide or precursor abundance matrix, with 
molecules in columns and samples in row (can contain missing values).}
}
\value{
List containing estimated fitted hyperparameters df (degrees of 
freedom) and psi (inverse scale).
}
\description{
Estimate the inverse-gamma parameters from the distribution of 
observed peptide variances in an abundance table.
}
\examples{
data(subbouyssie)
obj <- subbouyssie
# Keep only fully observed peptides
obs2NApep <- obj$peptides_ab[ ,colSums(is.na(obj$peptides_ab)) <= 0] 
estimate_psi_df(obs2NApep)


}
