% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createProfilePlot.R
\name{heatmapPlottingFast}
\alias{heatmapPlottingFast}
\title{Create profile heatmap plot using scattermore}
\usage{
heatmapPlottingFast(data = NULL, parm = NULL)
}
\arguments{
\item{data}{dataframe for plotting the heatmap phylogentic profile (either
full or subset profiles)}

\item{parm}{plot parameters, including (1) type of x-axis "taxa" or
"genes" - default = "taxa"; (2) display gene IDs (default) or gene names;
(3+4) names of 2 variables var1ID and var2ID - default = "var1" & "var2";
(5+6) mid value and color for mid value of var1 -
default is 0.5 and #FFFFFF; (7) color for lowest var1 - default = "#FF8C00";
(8) color for highest var1 - default = "#4682B4"; (9+10) mid value and color
for mid value of var2 - default is 1 and #FFFFFF;(11) color for lowest var2 -
default = "#FFFFFF", (12) color for highest var2 - default = "#F0E68C", (13)
color of co-orthologs - default = "#07D000"; (14+15+16) text sizes for x, y
axis and legend - default = 9 for each; (17) legend position "top", "bottom",
"right", "left" or "none" - default = "top"; (18) zoom ratio of the
co-ortholog dots from -1 to 3 - default = 0; (19) color dots based on either
"var1" or "var2". NOTE: Leave blank or NULL to
use default values.}
}
\value{
A profile heatmap plot as a ggplot object.
}
\description{
Create profile heatmap plot using scattermore
}
\examples{
data("finalProcessedProfile", package="PhyloProfile")
plotDf <- dataMainPlot(finalProcessedProfile)
plotParameter <- list(
    "xAxis" = "taxa",
    "geneIdType" = "geneID",
    "var1ID" = "FAS_FW",
    "var2ID"  = "FAS_BW",
    "midVar1" = 0.5,
    "midColorVar1" =  "#FFFFFF",
    "lowColorVar1" =  "#FF8C00",
    "highColorVar1" = "#4682B4",
    "midVar2" = 1,
    "midColorVar2" =  "#FFFFFF",
    "lowColorVar2" = "#CB4C4E",
    "highColorVar2" = "#3E436F",
    "paraColor" = "#07D000",
    "xSize" = 8,
    "ySize" = 8,
    "legendSize" = 8,
    "mainLegend" = "top",
    "dotZoom" = 0,
    "colorVar" = "var1"
)

heatmapPlottingFast(plotDf, plotParameter)
}
\seealso{
\code{\link{dataMainPlot}}, \code{\link{dataCustomizedPlot}}
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
