% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createTaxonomyMatrix.R
\name{taxonomyTableCreator}
\alias{taxonomyTableCreator}
\title{Align NCBI taxonomy IDs of list of taxa into a sorted rank list.}
\usage{
taxonomyTableCreator(idListFile = NULL, rankListFile = NULL)
}
\arguments{
\item{idListFile}{a text file whose each row is a rank+ID list of a taxon
(see idListFile in example)}

\item{rankListFile}{a text file whose each row is a rank list of a taxon
(see rankListFile in example)}
}
\value{
An aligned taxonomy dataframe which contains all the available
taxonomy ranks from the id and rank list file. This dataframe can be used for
creating a well resolved taxonomy tree (see ?createUnrootedTree) and sorting
taxa based on a selected reference taxon (see ?sortInputTaxa).
}
\description{
Align NCBI taxonomy IDs of list of taxa into a sorted rank list.
}
\examples{
idListFile <- system.file(
    "extdata", "data/idList.txt", package = "PhyloProfile", mustWork = TRUE
)
rankListFile <- system.file(
    "extdata", "data/rankList.txt", package = "PhyloProfile", mustWork = TRUE
)
taxonomyTableCreator(idListFile, rankListFile)
}
\seealso{
\code{\link{rankIndexing}}, \code{\link{createUnrootedTree}},
\code{\link{sortInputTaxa}}
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
