% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createTaxonomyMatrix.R
\name{processNcbiTaxonomy}
\alias{processNcbiTaxonomy}
\title{Pre-processing NCBI taxonomy data}
\usage{
processNcbiTaxonomy()
}
\value{
A dataframe contains NCBI taxon IDs, taxon names, taxon ranks and the
next higher taxon IDs (parent's IDs) of all taxa in the NCBI taxonomy
database.
}
\description{
Download NCBI taxonomy database and parse information that are
needed for PhyloProfile, including taxon IDs, their scientific names,
systematic ranks, and parent (next higher) rank IDs.
}
\examples{
\dontrun{
?processNcbiTaxonomy
preProcessedTaxonomy <- PhyloProfile:::processNcbiTaxonomy()
# save to text (tab-delimited) file
write.table(
    preProcessedTaxonomy,
    file = "preProcessedTaxonomy.txt",
    col.names = TRUE,
    row.names = FALSE,
    quote = FALSE,
    sep = "\t"
)
# save to rdata file
save(
    preProcessedTaxonomy, file = "preProcessedTaxonomy.RData", compress='xz'
)
}
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
