% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createTaxonomyMatrix.R
\name{id2name}
\alias{id2name}
\title{Get taxon names for a list of taxon IDs}
\usage{
id2name(idList = NULL, currentNCBIinfo = NULL)
}
\arguments{
\item{idList}{list of taxonomy IDs}

\item{currentNCBIinfo}{table/dataframe of the pre-processed NCBI taxonomy
data (/PhyloProfile/data/preProcessedTaxonomy.txt)}
}
\value{
A dataframe contains input taxon Ids and their full names.
}
\description{
Get taxon names for a list of taxon IDs
}
\examples{
ncbiFilein <- system.file(
    "extdata", "data/preProcessedTaxonomy.txt",
    package = "PhyloProfile", mustWork = TRUE
)
currentNCBIinfo <- as.data.frame(data.table::fread(ncbiFilein))
idList <- c("9606", "5207", "40674", "4751")
id2name(idList, currentNCBIinfo)
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
