% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createTaxonomyMatrix.R
\name{getTaxonomyInfo}
\alias{getTaxonomyInfo}
\title{Get taxonomy info for a list of input taxa}
\usage{
getTaxonomyInfo(inputTaxa = NULL, currentNCBIinfo = NULL)
}
\arguments{
\item{inputTaxa}{NCBI taxonomy IDs of input taxa.}

\item{currentNCBIinfo}{table/dataframe of the pre-processed NCBI taxonomy
data (/PhyloProfile/data/preProcessedTaxonomy.txt)}
}
\value{
A list of NCBI taxonomy info for input taxa, including the taxonomy
IDs, full scientific names, taxonomy ranks and the parent IDs.
}
\description{
Get taxonomy info for a list of input taxa
}
\examples{
inputTaxa <- c("272557", "176299")
ncbiFilein <- system.file(
    "extdata", "data/preProcessedTaxonomy.txt",
    package = "PhyloProfile", mustWork = TRUE
)
currentNCBIinfo <- as.data.frame(data.table::fread(ncbiFilein))
getTaxonomyInfo(inputTaxa, currentNCBIinfo)
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
