% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsePhyloProfile.R
\name{getSelectedTaxonNames}
\alias{getSelectedTaxonNames}
\title{Get a subset of input taxa based on a selected taxonomy rank}
\usage{
getSelectedTaxonNames(inputTaxonIDs = NULL, rank = NULL,
    higherRank = NULL, higherID = NULL, higherName = NULL, taxDB = NULL)
}
\arguments{
\item{inputTaxonIDs}{list of input taxon IDs (e.g. c("10116", "122586"))}

\item{rank}{taxonomy rank of input taxa (e.g. "species")}

\item{higherRank}{selected taxonomy rank (e.g. "phylum")}

\item{higherID}{supertaxon ID (e.g. 7711). NOTE: either supertaxon ID or
name is required, not neccessary to give both}

\item{higherName}{supertaxon name (e.g. "Chordata"). NOTE: either
supertaxon ID or name is required, not neccessary to give both}

\item{taxDB}{Path to the taxonomy DB files}
}
\value{
A data frame contains ncbi IDs and names of taxa from the input taxon
list that belong to the selected supertaxon.
}
\description{
Get a subset of taxon ncbi IDs and names from an input list of
taxa based on a selected supertaxon (identified by its taxonomy rank and
supertaxon name or supertaxon ID).
}
\examples{
inputTaxonIDs <- c("10116", "122586", "123851", "13616", "188937", "189518",
"208964", "224129", "224324", "237631", "243230")
rank <- "species"
higherRank <- "phylum"
higherID <- 7711
getSelectedTaxonNames(inputTaxonIDs, rank, higherRank, higherID, NULL)
higherName <- "Chordata"
getSelectedTaxonNames(inputTaxonIDs, rank, higherRank, NULL, higherName,NULL)
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
