% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareTaxaGroups.R
\name{getCommonAncestor}
\alias{getCommonAncestor}
\title{Get all taxa that share a common ancestor}
\usage{
getCommonAncestor(inputTaxa = NULL, inGroup = NULL, taxDB = NULL)
}
\arguments{
\item{inputTaxa}{ID list of all input taxa (e.g. "ncbi12345")}

\item{inGroup}{ID list of selected taxa used for identify the common ancestor
(e.g.: "ncbi55555")}

\item{taxDB}{Path to the taxonomy DB files}
}
\value{
A list containing the taxonomy rank and name of the common ancestor,
together with a dataframe storing the full taxonomy info of all taxa that
share that corresponding common ancestor.
}
\description{
Identify the common ancestor for a selected taxa and return a
list of all taxa that have that common ancestor from an large input taxa set.
}
\examples{
inputTaxa <- c("ncbi34740", "ncbi9606", "ncbi374847", "ncbi123851",
    "ncbi5664", "ncbi189518", "ncbi418459", "ncbi10116", "ncbi284812",
    "ncbi35128", "ncbi7070")
inGroup <-  c("ncbi9606", "ncbi10116")
getCommonAncestor(inputTaxa, inGroup)
}
\author{
Vinh Tran (tran@bio.uni-frankfurt.de)
}
