% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{selectGrps}
\alias{selectGrps}
\title{Select by treatment groups (replicate block)}
\usage{
selectGrps(mat, grps, percent, n, assay)
}
\arguments{
\item{mat}{a matrix (PhosphoExperiment object) with rows correspond to 
phosphosites and columns correspond to samples in replicates for different 
treatments.}

\item{grps}{a string specifying the grouping (replicates).}

\item{percent}{a percent from 0 to 1, specifying the percentage of quantified
values in any treatment group.}

\item{n}{an integer indicating n or more replicates pass the percentage
filtering for a phosphosite to be included.}

\item{assay}{an assay to be selected if \code{mat} is a PhosphoExperiment 
object.}
}
\value{
a filtered matrix (or a PhosphoExperiment Oject) with at least 
'percent' quantification in one or more conditions. If an input \code{mat} is 
a SummarizedExperiment object, filtered SummarizedExperiment object will be 
returned.
}
\description{
Select phosphosites that have been quantified in a given
percentage of treatment groups (e.g. 0.75 as 3 out of 4 replicates)
in n groups.
}
\examples{
data('phospho.cells.Ins.sample')
grps = gsub('_[0-9]{1}', '', colnames(phospho.cells.Ins))
phospho.cells.Ins.filtered <- selectGrps(phospho.cells.Ins, grps, 0.5, n=1)

# For PhosphoExperiment object
data('phospho.cells.Ins.pe')
grps = gsub('_[0-9]{1}', '', colnames(phospho.cells.Ins.pe))
phospho.cells.Ins.filtered <- selectGrps(phospho.cells.Ins.pe, grps, 0.5, n=1)

}
\author{
Pengyi Yang, Taiyun Kim
}
