% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Signalomes.R
\name{Signalomes}
\alias{Signalomes}
\title{PhosR Signalomes}
\usage{
Signalomes(KSR, predMatrix, exprsMat, KOI, threskinaseNetwork=0.9,
signalomeCutoff=0.5, module_res = NULL, filter = FALSE, verbose = TRUE)
}
\arguments{
\item{KSR}{kinase-substrate relationship scoring results}

\item{predMatrix}{output of kinaseSubstratePred function}

\item{exprsMat}{a matrix with rows corresponding to phosphosites and columns
corresponding to samples}

\item{KOI}{a character vector that contains kinases of interest for which
expanded signalomes will be generated}

\item{threskinaseNetwork}{threshold used to select interconnected kinases for
the expanded signalomes}

\item{signalomeCutoff}{threshold used to filter kinase-substrate
relationships}

\item{module_res}{parameter to select number of final modules}

\item{filter}{parameter to filter modules with only few proteins}

\item{verbose}{Default to \code{TRUE} to show messages during the progress.
All messages will be suppressed if set to \code{FALSE}}
}
\value{
A list of 3 elements.
 \code{Signalomes}, \code{proteinModules} and \code{kinaseSubstrates}
}
\description{
A function to generate signalomes
}
\examples{
\donttest{
data('phospho_L6_ratio_pe')
data('SPSs')
data('PhosphoSitePlus')

grps = gsub('_.+', '', colnames(phospho.L6.ratio.pe))

# Construct a design matrix by condition
design = model.matrix(~ grps - 1)

# phosphoproteomics data normalisation using RUV

L6.sites = paste(sapply(GeneSymbol(phospho.L6.ratio.pe), function(x)paste(x)),
                 ";",
                 sapply(Residue(phospho.L6.ratio.pe), function(x)paste(x)),
                 sapply(Site(phospho.L6.ratio.pe), function(x)paste(x)),
                 ";", sep = "")
ctl = which(L6.sites \%in\% SPSs)
phospho.L6.ratio.RUV = RUVphospho(
    SummarizedExperiment::assay(phospho.L6.ratio.pe, "Quantification"), 
    M = design, k = 3, ctl = ctl)

phosphoL6 = phospho.L6.ratio.RUV

# filter for up-regulated phosphosites
phosphoL6.mean <- meanAbundance(phosphoL6, grps = grps)
aov <- matANOVA(mat=phosphoL6, grps=grps)
phosphoL6.reg <- phosphoL6[(aov < 0.05) &
                         (rowSums(phosphoL6.mean > 0.5) > 0),, drop = FALSE]
L6.phos.std <- standardise(phosphoL6.reg)
idx <- match(rownames(L6.phos.std), rownames(phospho.L6.ratio.pe))
rownames(L6.phos.std) <- L6.sites[idx]

L6.phos.seq <- Sequence(phospho.L6.ratio.pe)[idx]

L6.matrices <- kinaseSubstrateScore(PhosphoSite.mouse, L6.phos.std,
                                    L6.phos.seq, numMotif = 5, numSub = 1)
set.seed(1)
L6.predMat <- kinaseSubstratePred(L6.matrices, top=30)

kinaseOI = c('PRKAA1', 'AKT1')

Signalomes_results <- Signalomes(KSR=L6.matrices,
                                 predMatrix=L6.predMat,
                                 exprsMat=L6.phos.std,
                                 KOI=kinaseOI)
}

}
