% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intersectPSets.R
\name{intersectPSet}
\alias{intersectPSet}
\title{Intersects objects of the PharmacoSet class, subsetting them to the common
drugs and/or cell lines as selected by the user.}
\usage{
intersectPSet(
  pSets,
  intersectOn = c("drugs", "cell.lines", "concentrations"),
  cells,
  drugs,
  strictIntersect = FALSE,
  verbose = TRUE,
  nthread = 1
)
}
\arguments{
\item{pSets}{\code{list} a list of PharmacoSet objects, of which the function
should find the intersection}

\item{intersectOn}{\code{character} which identifiers to intersect on,
drugs, cell lines, or concentrations}

\item{cells}{a \code{character}vector of common cell lines between pSets.
In case user is intersted on getting intersection on certain cell lines,
they can provide their list of cell lines}

\item{drugs}{a \code{character} vector of common drugs between pSets.
In case user is intersted on getting intersection on certain drugs,
they can provide their list of drugs.}

\item{strictIntersect}{\code{boolean} Should the intersection keep only the drugs
and cell lines that have been tested on together?}

\item{verbose}{\code{boolean} Should the function announce its key steps?}

\item{nthread}{\code{numeric} The number of cores to use to run intersection on
concentrations}
}
\value{
A \code{list} of pSets, contatining only the intersection
}
\description{
Given a list of PharmacoSets, the function will find the common drugs,
and/or cell lines, and return PharmacoSets that contain data only pertaining
to the common drugs, and/or cell lines. The mapping between dataset
drug and cell names is done using annotations found in the
PharmacoSet object's internal curation slot
}
\examples{
data(GDSCsmall)
data(CCLEsmall)
common <- intersectPSet(list('GDSC'=GDSCsmall,'CCLE'=CCLEsmall),
                        intersectOn = c("drugs", "cell.lines"))
common$CGP
common$CCLE

}
