% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeSynergy.R
\name{hillCurve}
\alias{hillCurve}
\title{4-Parameter Hill Equation for Stimuli-Response Curves}
\usage{
hillCurve(dose, HS, EC50, E_inf, E_ninf)
}
\arguments{
\item{dose}{\code{numeric()} A vector of \code{log10(dose)} values (or equivalent for
the stimuli being modelleled).}

\item{HS}{\code{numeric(1)} Hill coefficient (n) which defines the slope of the
dose-response curve at the mid-point. This parameter describes the degree
of sigmoidicity of the Hill curve. HS = 1 corresponds to the rectangular
hyperbola in dose-response space.}

\item{EC50}{\code{numeric(1)} The dose required to produce 50\% of the
theoretically maximal response in the system, \code{E_inf}. Should be in the same
units as \code{dose}!}

\item{E_inf}{\code{numeric(1)} Theoretical maximal response (minimal viability)
in the system as a proportion in the range \[0, 1\]. Note that since we are
predicting viability (percent of cells alive after treatment) instead of
response, this value should be low (i.e., more cell killing).}

\item{E_ninf}{\code{numeric(1)} Theoretical minimum response (basal response).
Defaults to 1, which should be the case for most viability experiments since
we expect no cell killing to occur prior to applying a treatment.}
}
\value{
\code{numeric()} Vector of predicted viabilities for the Hill curve defined
by \code{EC50}, \code{E_inf}, \code{E_ninf} and \code{HS} for each supplied value of \code{dose}.
}
\description{
Sigmoidal function which fits well to many stimuli-response associations
observed in biology and pharmacology. In the context of PharmacoGx we
are using it to model treatment-response assocations in cancer cell lines.
}
\examples{
(viability <- hillCurve(
  dose=c(0.1, 0.01, 0.001),
  HS=1.1,
  EC50=0.01,
  E_ninf=1,
  E_inf=0
))

}
\references{
Gesztelyi, R., Zsuga, J., Kemeny-Beke, A., Varga, B., Juhasz, B., &
Tosaki, A. (2012). The Hill equation and the origin of quantitative
pharmacology. Archive for History of Exact Sciences, 66(4), 427–438.
https://doi.org/10.1007/s00407-012-0098-5

Motulsky, H., & Christopoulos, A. (2004). Fitting models to biological data
using linear and nonlinear regression: A practical guide to curve fitting.
Oxford University Press. See Chapter 41.
}
\author{
Feifei Li
Petr Smirnov
Christopher Eeles
}
