% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drugDoseResponseCurve.R
\name{drugDoseResponseCurve}
\alias{drugDoseResponseCurve}
\title{Plot drug response curve of a given drug and a given cell for a list of pSets (objects of the PharmacoSet class).}
\usage{
drugDoseResponseCurve(
  drug,
  cellline,
  pSets = list(),
  concentrations = list(),
  viabilities = list(),
  conc_as_log = FALSE,
  viability_as_pct = TRUE,
  trunc = TRUE,
  legends.label = c("ic50_published", "gi50_published", "auc_published",
    "auc_recomputed", "ic50_recomputed"),
  ylim = c(0, 100),
  xlim,
  mycol,
  title,
  plot.type = c("Fitted", "Actual", "Both"),
  summarize.replicates = TRUE,
  lwd = 0.5,
  cex = 0.7,
  cex.main = 0.9,
  legend.loc = "topright",
  verbose = TRUE,
  sample_col = "sampleid",
  treatment_col = "treatmentid"
)
}
\arguments{
\item{drug}{\code{character(1)} A drug name for which the drug response curve should be
plotted. If the plot is desirable for more than one pharmaco set, A unique drug id
should be provided.}

\item{cellline}{\code{character(1)} A cell line name for which the drug response curve should be
plotted. If the plot is desirable for more than one pharmaco set, A unique cell id
should be provided.}

\item{pSets}{\code{list} a list of PharmacoSet objects, for which the function
should plot the curves.}

\item{concentrations, viabilities}{\code{list} A list of concentrations and viabilities to plot, the function assumes that
\code{concentrations[[i]]} is plotted against \code{viabilities[[i]]}. The names of the concentration list are used to create the legend labels}

\item{conc_as_log}{\code{logical}, if true, assumes that log10-concentration data has been given rather than concentration data,
and that log10(ICn) should be returned instead of ICn. Applies only to the concentrations parameter.}

\item{viability_as_pct}{\code{logical}, if false, assumes that viability is given as a decimal rather
than a percentage, and that E_inf passed in as decimal. Applies only to the viabilities parameter.}

\item{trunc}{\code{logical(1)} Should the viability values be truncated to lie in [0-100] before doing the fitting}

\item{legends.label}{\code{numeric} A vector of sensitivity measurment types which could
be any combination of  ic50_published, auc_published, auc_recomputed and auc_recomputed_star.
A legend will be displayed on the top right of the plot which each line of the legend is
the values of requested sensitivity measerments for one of the requested pSets.
If this parameter is missed no legend would be provided for the plot.}

\item{ylim}{\code{numeric} A vector of two numerical values to be used as ylim of the plot.
If this parameter would be missed c(0,100) would be used as the ylim of the plot.}

\item{xlim}{\code{numeric} A vector of two numerical values to be used as xlim of the plot.
If this parameter would be missed the minimum and maximum comncentrations between all
the pSets would be used as plot xlim.}

\item{mycol}{\code{numeric} A vector with the same lenght of the pSets parameter which
will determine the color of the curve for the pharmaco sets. If this parameter is
missed default colors from Rcolorbrewer package will be used as curves color.}

\item{title}{\code{character} The title of the graph. If no title is provided, then it defaults to
'Drug':'Cell Line'.}

\item{plot.type}{\code{character} Plot type which can be the actual one ("Actual") or
the one fitted by logl logistic regression ("Fitted") or both of them ("Both").
If this parameter is missed by default actual curve is plotted.}

\item{summarize.replicates}{\code{character} If this parameter is set to true replicates
are summarized and replicates are plotted individually otherwise}

\item{lwd}{\code{numeric} The line width to plot with}

\item{cex}{\code{numeric} The cex parameter passed to plot}

\item{cex.main}{\code{numeric} The cex.main parameter passed to plot, controls the size of the titles}

\item{legend.loc}{And argument passable to xy.coords for the position to place the legend.}

\item{verbose}{\code{logical(1)} Should warning messages about the data passed in be printed?}

\item{sample_col}{\code{character(1)} The name of the column in the profiles assay that contains the sample IDs.}

\item{treatment_col}{\code{character(1)} The name of the column in the profiles assay that contains the treatment IDs.}
}
\value{
Plots to the active graphics device and returns an invisible NULL.
}
\description{
Given a list of PharmacoSets, the function will plot the drug_response curve,
for a given drug/cell pair. The y axis of the plot is the viability percentage
and x axis is the log transformed concentrations. If more than one pSet is
provided, a light gray area would show the common concentration range between pSets.
User can ask for type of sensitivity measurment to be shown in the plot legend.
The user can also provide a list of their own concentrations and viability values,
as in the examples below, and it will be treated as experiments equivalent to values coming
from a pset. The names of the concentration list determine the legend labels.
}
\examples{
if (interactive()) {
# Manually enter the plot parameters
drugDoseResponseCurve(concentrations=list("Experiment 1"=c(.008, .04, .2, 1)),
 viabilities=list(c(100,50,30,1)), plot.type="Both")

# Generate a plot from one or more PSets
data(GDSCsmall)
drugDoseResponseCurve(drug="Doxorubicin", cellline="22RV1", pSets=GDSCsmall)
}

}
