% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alias.R
\name{aliases}
\alias{aliases}
\alias{getAlias}
\alias{setAlias}
\alias{deleteAlias}
\title{Using aliases to subset virus data}
\usage{
getAlias(virus)

setAlias(virus, pattern)

deleteAlias(virus)
}
\arguments{
\item{virus}{character vector of the alias}

\item{pattern}{character vector of regexpressions corresponding to the alias}
}
\value{
\code{getAlias()} returns a vector of regexpressions corresponding to
queried inputs. The returned vector is the same length as the input vector.
Queries that do not exist in the database return \code{NA_character_}.
}
\description{
Rather than typing out full viruses names or repeating
regexpressions, users can use aliases as a convenient tool to subset
\code{PhIPData} objects by viral species.
}
\details{
Aliases are cached to an rda file containing only a
\code{data.frame} with two columns: \code{alias} and \code{pattern}. The
\code{alias} column contains the alias while the \code{pattern} column
contains the corresponding regexpression of interest.

Once an alias is added to the database, it can always be accessed once the
package is loaded. It is recommended to use the functions \code{setAlias}
and \code{deleteAlias}. If an alias already exists in the database,
\code{setAlias} replaces the matched pattern. If an alias does not exist
in the database, \code{getAlias} returns \code{NA_character_}.
}
\section{Functions}{
\itemize{
\item \code{getAlias}: return a regexpression corresponding to the alias.

\item \code{setAlias}: define/modify the regexpression for an alias.

\item \code{deleteAlias}: remove an alias from the database.
}}

\examples{

## Edit and modify aliases in the database
setAlias("test_virus", "test_pattern")
getAlias("test_virus")
setAlias("test_virus", "test_pattern2")
getAlias("test_virus")
deleteAlias("test_virus")

## Edit and modify multiple aliases at once.
setAlias(c("virus_1", "virus_2"), c("pattern_1", "pattern_2"))
getAlias(c("virus_1", "virus_2"))
deleteAlias(c("virus_1", "virus_2"))

## Example of how to subset HIV using `getAlias`
## Often, it is useful to set the `ignore.case` of `grep`/`grepl` to TRUE.
counts_dat <- matrix(1:10, nrow = 5)
peptide_meta <- data.frame(species = c(
    rep("Epstein-Barr virus", 2),
    rep("human immunodeficiency virus", 3)
))

phip_obj <- PhIPData(counts = counts_dat, peptideInfo = peptide_meta)
subset(phip_obj, grepl(getAlias("HIV"), species, ignore.case = TRUE))
}
