% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EnframeContrastsRes.R
\name{EnframeContrastsRes}
\alias{EnframeContrastsRes}
\title{Enframe result of LIMMA analysis}
\usage{
EnframeContrastsRes(eBayes.fit, eb = TRUE)
}
\arguments{
\item{eBayes.fit}{output from \code{FitContrasts}. See ?\code{limma::eBayes} for details.}

\item{eb}{logical, whether to output the result from the empirical Bayes or ordinary approach.}
}
\value{
\code{EnframeContrastsRes} returns a dataframe containing the following columns
\item{feature}{unique feature identifier}
\item{logFC}{log2 fold change}
\item{t}{t-statistic}
\item{P.Value}{raw p-value}
\item{adj.P.Val}{p-value adjusted via the Benjamini-Hochberg method}
\item{B}{B-statistic (empirical Bayes only)}
}
\description{
Convert result of LIMMA analysis into a dataframe.
}
\examples{
# Generate random peptide data
dat <- 2^matrix(rnorm(3000), ncol = 6)
colnames(dat) <- paste0("Sample", 1:6)
rownames(dat) <- paste0("Peptide", 1:500)

# Generate groups and contrasts
group <- c(rep("A", 3), rep("B", 3))
contrasts.par <- "B-A"

fit.cont <- FitContrasts(dat, contrasts.par, group)
EnframeContrastsRes(fit.cont)

}
\author{
Junmin Wang
}
